/*
 * Decompiled with CFR 0.152.
 */
package net.theobsessed.network;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.theobsessed.TheObsessedMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheObsessedModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"the_obsessed");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheObsessedMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        TheObsessedMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_obsessed", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_obsessed", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean idktarget = false;
        public double idkmood = 0.0;
        public double idkhealth_perplayer = 0.0;
        public boolean gift1 = false;
        public boolean gift2 = false;
        public boolean gift3 = false;
        public boolean obsessedpopup = false;
        public boolean debug_command = false;
        public boolean one_time_splash = false;
        public double obsession_length = 0.0;
        public boolean gift4 = false;
        public boolean gift5 = false;
        public boolean gift6 = false;
        public boolean gift7 = false;
        public String message_memory = "\"\"";
        public String store_chats = "\"\"";
        public String store_chats_2 = "\"\"";
        public String store_chats_3 = "\"\"";
        public String store_chats_4 = "\"\"";
        public String store_chats_5 = "\"\"";
        public boolean gift8 = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("idktarget", this.idktarget);
            nbt.putDouble("idkmood", this.idkmood);
            nbt.putDouble("idkhealth_perplayer", this.idkhealth_perplayer);
            nbt.putBoolean("gift1", this.gift1);
            nbt.putBoolean("gift2", this.gift2);
            nbt.putBoolean("gift3", this.gift3);
            nbt.putBoolean("obsessedpopup", this.obsessedpopup);
            nbt.putBoolean("debug_command", this.debug_command);
            nbt.putBoolean("one_time_splash", this.one_time_splash);
            nbt.putDouble("obsession_length", this.obsession_length);
            nbt.putBoolean("gift4", this.gift4);
            nbt.putBoolean("gift5", this.gift5);
            nbt.putBoolean("gift6", this.gift6);
            nbt.putBoolean("gift7", this.gift7);
            nbt.putString("message_memory", this.message_memory);
            nbt.putString("store_chats", this.store_chats);
            nbt.putString("store_chats_2", this.store_chats_2);
            nbt.putString("store_chats_3", this.store_chats_3);
            nbt.putString("store_chats_4", this.store_chats_4);
            nbt.putString("store_chats_5", this.store_chats_5);
            nbt.putBoolean("gift8", this.gift8);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.idktarget = nbt.getBoolean("idktarget");
            this.idkmood = nbt.getDouble("idkmood");
            this.idkhealth_perplayer = nbt.getDouble("idkhealth_perplayer");
            this.gift1 = nbt.getBoolean("gift1");
            this.gift2 = nbt.getBoolean("gift2");
            this.gift3 = nbt.getBoolean("gift3");
            this.obsessedpopup = nbt.getBoolean("obsessedpopup");
            this.debug_command = nbt.getBoolean("debug_command");
            this.one_time_splash = nbt.getBoolean("one_time_splash");
            this.obsession_length = nbt.getDouble("obsession_length");
            this.gift4 = nbt.getBoolean("gift4");
            this.gift5 = nbt.getBoolean("gift5");
            this.gift6 = nbt.getBoolean("gift6");
            this.gift7 = nbt.getBoolean("gift7");
            this.message_memory = nbt.getString("message_memory");
            this.store_chats = nbt.getString("store_chats");
            this.store_chats_2 = nbt.getString("store_chats_2");
            this.store_chats_3 = nbt.getString("store_chats_3");
            this.store_chats_4 = nbt.getString("store_chats_4");
            this.store_chats_5 = nbt.getString("store_chats_5");
            this.gift8 = nbt.getBoolean("gift8");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_mapvars";
        public String log_last_type_attempt = "\"\"";
        public String log_last_type__attempt_origin = "\"\"";
        public double obsessed_exists = 0.0;
        public boolean global_normaltick = false;
        public double obs_x = 0.0;
        public double obs_y = 0.0;
        public double obs_z = 0.0;
        public double obs_yaw = 0.0;
        public String last_despawn_reason = "\"\"";
        public String single_player_target_uuid = "\"\"";
        public double time_without_finding_single_target = 0.0;
        public double targeter_exists = 0.0;
        public double chat_cooldown = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.log_last_type_attempt = nbt.getString("log_last_type_attempt");
            this.log_last_type__attempt_origin = nbt.getString("log_last_type__attempt_origin");
            this.obsessed_exists = nbt.getDouble("obsessed_exists");
            this.global_normaltick = nbt.getBoolean("global_normaltick");
            this.obs_x = nbt.getDouble("obs_x");
            this.obs_y = nbt.getDouble("obs_y");
            this.obs_z = nbt.getDouble("obs_z");
            this.obs_yaw = nbt.getDouble("obs_yaw");
            this.last_despawn_reason = nbt.getString("last_despawn_reason");
            this.single_player_target_uuid = nbt.getString("single_player_target_uuid");
            this.time_without_finding_single_target = nbt.getDouble("time_without_finding_single_target");
            this.targeter_exists = nbt.getDouble("targeter_exists");
            this.chat_cooldown = nbt.getDouble("chat_cooldown");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putString("log_last_type_attempt", this.log_last_type_attempt);
            nbt.putString("log_last_type__attempt_origin", this.log_last_type__attempt_origin);
            nbt.putDouble("obsessed_exists", this.obsessed_exists);
            nbt.putBoolean("global_normaltick", this.global_normaltick);
            nbt.putDouble("obs_x", this.obs_x);
            nbt.putDouble("obs_y", this.obs_y);
            nbt.putDouble("obs_z", this.obs_z);
            nbt.putDouble("obs_yaw", this.obs_yaw);
            nbt.putString("last_despawn_reason", this.last_despawn_reason);
            nbt.putString("single_player_target_uuid", this.single_player_target_uuid);
            nbt.putDouble("time_without_finding_single_target", this.time_without_finding_single_target);
            nbt.putDouble("targeter_exists", this.targeter_exists);
            nbt.putDouble("chat_cooldown", this.chat_cooldown);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_obsessed_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.idktarget = original.idktarget;
            clone.idkmood = original.idkmood;
            clone.idkhealth_perplayer = original.idkhealth_perplayer;
            clone.gift1 = original.gift1;
            clone.gift2 = original.gift2;
            clone.gift3 = original.gift3;
            clone.one_time_splash = original.one_time_splash;
            clone.obsession_length = original.obsession_length;
            clone.gift4 = original.gift4;
            clone.gift5 = original.gift5;
            clone.gift6 = original.gift6;
            clone.gift7 = original.gift7;
            clone.message_memory = original.message_memory;
            clone.store_chats = original.store_chats;
            clone.store_chats_2 = original.store_chats_2;
            clone.store_chats_3 = original.store_chats_3;
            clone.store_chats_4 = original.store_chats_4;
            clone.store_chats_5 = original.store_chats_5;
            clone.gift8 = original.gift8;
            if (!event.isWasDeath()) {
                clone.obsessedpopup = original.obsessedpopup;
                clone.debug_command = original.debug_command;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

