package com.feintha.dpu;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Function3;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;

public class DPU {
    public static class DPUWorkerThread_T extends Thread{
        public DPUWorkerThread_T(int id) {
            super("DPUWorkerThread" + id);
        }
        public Function<Object, Object> currentMethod;
        public Object data;
        private boolean completed = false;
        public boolean isCompleted() { return completed; }
        public boolean isBusy() { return !completed; }

        @Override
        public void run() {
            super.run();
            completed = false;
            currentMethod.apply(data);
            completed = true;
        }
    }
    public static ThreadPoolExecutor DPUWorkerThreads;
    public static final class_5321<class_2378<DPUEventType>> EVENT_TYPE_KEYS = class_5321.method_29180(new class_2960("dpu", "eventtypes"));
    public static final class_2378<DPUEventType> EVENT_TYPE = FabricRegistryBuilder.createSimple(EVENT_TYPE_KEYS).buildAndRegister();
    public static void InitEverything() {
        DPUEventType._MINIT();
        for (var entry : EVENT_TYPE.method_29722()) {
            entry.getValue().Events.clear();
        }
        DPUWorkerThreads = (ThreadPoolExecutor) Executors.newFixedThreadPool(8);
    }
    public static void InvokeClientEventFor(DPUEventType type, class_2960 idToRun) {
        class_2960 id = new class_2960("cl_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("cl_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        if (action != null) {
            action.doActionClient();
        }
        if (actionS != null) {
            actionS.doActionClient();
        }
    }
    public static void InvokeServerEventFor(DPUEventType type, class_2960 idToRun, class_3218 world, @NotNull class_1297 owner) {
        class_2960 id = new class_2960("sv_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("sv_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        if (action != null) {
            action.doActionServer(world, owner);
        }
        if (actionS != null) {
            actionS.doActionServer(world,owner);
        }
    }
    public static void InvokeClientEventForAt(DPUEventType type, class_2960 idToRun, class_243 pos) {
        class_2960 id = new class_2960("cl_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("cl_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        if (action != null) {
            action.doActionClientAt(pos);
        }
        if (actionS != null) {
            actionS.doActionClientAt(pos);
        }
    }
    public static void InvokeServerEventForAt(DPUEventType type, class_2960 idToRun, class_243 pos, class_3218 world, class_1297 owner) {
        class_2960 id = new class_2960("sv_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("sv_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        if (action != null) {
            action.doActionServerAt(world, owner, pos);
        }
        if (actionS != null) {
            actionS.doActionServerAt(world,owner, pos);
        }
    }
    public static void InitClientEvents() {
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return new class_2960("feintha", "dpu_resource_pack_listener");
            }
            final String SIDE = "cl_";
            final String r_M = "\\/([A-Za-z0-9_.-]+)\\.json";
            @Override
            public void method_14491(class_3300 manager) {
                int l = 0;
                for (var entry : EVENT_TYPE.method_29722()) {
                    class_2960 __id = entry.getKey().method_29177();
                    String _path = "events/" + __id.method_12832();
                    var on_use_files = manager.method_14488(_path, path -> path.method_12832().endsWith(".json"));
                    for (var id : on_use_files.keySet()) {
                        var file = on_use_files.get(id);
                        String itemName = id.method_12832().replaceAll(".*/(.*?)\\.json", "$1");
                        class_2960 itemID = new class_2960(id.method_12836(), itemName);
                        class_2960 registryID = new class_2960(SIDE+itemID.method_12836(), itemID.method_12832());
                        try {
                            String input = new String(file.method_14482().readAllBytes(), StandardCharsets.UTF_8);
                            entry.getValue().addSubEvent(registryID, entry.getValue().createEventType(new JsonParser().parse(input).getAsJsonObject()));
                            l++;
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                System.out.println("Loaded " + l + " server-side events.");
            }
        });
        EVENT_TYPE.method_42021().forEach(k -> {
            System.out.println(k.method_29177());
        });

    }
    public static void InitServerEvents() {
        ServerTickEvents.START_SERVER_TICK.register(world -> {
            if (world.method_3780() <= 1) {
                DPUDataStorage.InitServer(world);
            }
        });
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return new class_2960("feintha", "dpu_data_pack_listener");
            }

            final String r_M = "\\/([A-Za-z0-9_.-]+)\\.json";
            final String SIDE = "sv_";
            @Override
            public void method_14491(class_3300 manager) {
                int l = 0;
                for (var entry : EVENT_TYPE.method_29722()) {
                    class_2960 __id = entry.getKey().method_29177();
                    String _path = "events/" + __id.method_12832();
                    var on_use_files = manager.method_14488(_path, path -> path.method_12832().endsWith(".json"));
                    for (var id : on_use_files.keySet()) {
                        var file = on_use_files.get(id);
                        String itemName = id.method_12832().replaceAll(".*/(.*?)\\.json", "$1");
                        class_2960 itemID = new class_2960(id.method_12836(), itemName);
                        class_2960 registryID = new class_2960(SIDE+itemID.method_12836(), itemID.method_12832());

                        try {
                            String input = new String(file.method_14482().readAllBytes(), StandardCharsets.UTF_8);
                            entry.getValue().addSubEvent(registryID, entry.getValue().createEventType(new JsonParser().parse(input).getAsJsonObject()));
                            l++;
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                System.out.println("Loaded " + l + " server-side events.");
            }
        });
        EVENT_TYPE.method_42021().forEach(k -> {
            System.out.println(k.method_29177());
        });
    }



    public static void InvokeAllClientEventsFor(DPUEventType type) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("cl_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionClient();
                }
            }
        }
    }
    public static void InvokeAllServerEventsFor(DPUEventType type, class_3218 world, @NotNull class_1657 owner) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("sv_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionServer(world, owner);
                }
            }
        }
    }
    public static Collection<DPUEvent> getAllClientEventsFor(DPUEventType type) {
        ArrayList<DPUEvent> ev = new ArrayList<>();
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("cl_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    ev.add(action);
                }
            }
        }
        return ev;
    }
    public static Collection<DPUEvent> getAllServerEventsFor(DPUEventType type) {
        ArrayList<DPUEvent> ev = new ArrayList<>();
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("sv_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    ev.add(action);
                }
            }
        }
        return ev;
    }
    public static void InvokeAllClientEventsForAt(DPUEventType type, class_243 pos) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("cl_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionClientAt(pos);
                }
            }
        }
    }
    public static void InvokeAllServerEventsForAt(DPUEventType type, class_3218 world, @NotNull class_1657 owner, class_243 pos) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("sv_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionServerAt(world, owner, pos);
                }
            }
        }
    }


}
