package com.feintha.dpu;

import com.feintha.dpu.client.DatapackUtilsClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class DPUEvent {
    public class_2960 function = null;
    public boolean serverOnly = false;
    public int actionLastTick = 0;
    public int requiredTickDelay = 0;

    public static JsonArray DESERIALIZE_OFFSET_ZERO = new JsonArray();
    static {
        DESERIALIZE_OFFSET_ZERO.add(0);
        DESERIALIZE_OFFSET_ZERO.add(0);
        DESERIALIZE_OFFSET_ZERO.add(0);
    }
    public class_3414 sound;

    @SuppressWarnings("rawtypes")
    public class_2396 particle;
    // Particle offset. Uses camera rotation.
    public class_243 ParticleOffset = new class_243(0,0,0);
    public float SoundVolume = 1f;
    public float SoundPitch = 1f;

    public DPUEvent(JsonObject o){
        Deserialize(o);
    }
    public DPUEvent(String input){
        this(new JsonParser().parse(input).getAsJsonObject());
    }


    protected final void handleParticles(){
        assert class_310.method_1551().field_1687 != null;
        if (particle != null) {
            assert class_310.method_1551().field_1724 != null;
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            class_243 rot = class_310.method_1551().field_1724.method_5663();
            class_243 pOff = ParticleOffset.method_18806(rot).method_1019(pos);
            class_310.method_1551().field_1687.method_8406((class_2394) particle, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleParticlesAt(class_243 pos){
        assert class_310.method_1551().field_1687 != null;
        if (particle != null) {
            class_243 pOff = ParticleOffset.method_1019(pos);
            class_310.method_1551().field_1687.method_8406((class_2394) particle, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleServerParticles(class_3218 world, class_1297 owner){
        if (particle != null) {
            class_243 pos = owner.method_33571();
            class_243 rot = owner.method_5720();
            class_243 pOff = ParticleOffset.method_18806(rot).method_1019(pos);
            world.method_8466((class_2394) particle, true, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleServerParticlesAt(class_3218 world, class_1297 owner, class_243 pos){
        if (particle != null) {
            class_243 pOff = ParticleOffset.method_1019(pos);
            world.method_8466((class_2394) particle, true, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleFunction(class_3218 world, class_1297 owner) {
        if (function != null) {
            var func = world.method_8503().method_3740().method_12905(function);
            if (func.isPresent()) {
                if (owner == null || !owner.method_31747()) {
                    world.method_8503().method_3740().method_12904(func.get(), world.method_8503().method_3739());
                } else {
                    world.method_8503().method_3740().method_12904(func.get(), owner.method_5671());
                }
            } else {
                System.out.println("Unable to execute function " + function + " when using event.");
            }
        }
    }
    protected final void handleFunctionAt(class_3218 world, class_1297 owner, class_243 pos) {
        if (function != null) {
            var func = world.method_8503().method_3740().method_12905(function);
            if (func.isPresent()) {
                if (owner == null || !owner.method_31747()) {
                    world.method_8503().method_3740().method_12904(func.get(), world.method_8503().method_3739().method_9208(pos));
                } else {
                    world.method_8503().method_3740().method_12904(func.get(), owner.method_5671().method_9208(pos));
                }
            } else {
                System.out.println("Unable to execute function " + function + " when using event.");
            }
        }
    }
    protected final void handleSound(){
        assert class_310.method_1551().field_1687 != null;
        if (sound != null) {
            // hacky solutions are sometimes the only solution :despair:
            assert class_310.method_1551().field_1724 != null;
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            class_310.method_1551().field_1687.method_8486(pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch, true);
        }
    }
    protected final void handleServerSound(class_3218 w, class_1297 owner){
        if (sound != null) {
            class_243 pos = owner.method_33571();
            w.method_43128(null, pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch);
        }
    }
    protected final void handleServerSoundAt(class_3218 w, class_1297 owner, class_243 pos){
        if (sound != null) {
            w.method_43128(null, pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch);
        }
    }
    public void doActionClient(){
        handleSound();
        handleParticles();
    }
    public void doActionClientAt(class_243 pos){
        handleSound();
        handleParticles();
    }
    public void doActionServer(class_3218 world) {
        DatapackUtils.ScheduleForNextTick((s) -> {
            handleFunction(world, null);
            handleServerSound(world, null);
            handleServerParticles(world, null);
        });
    }
    public void doActionServerAt(class_3218 world, class_243 pos) {
        DatapackUtils.ScheduleForNextTick((s) -> {
            handleFunctionAt(world, null, pos);
            handleServerSoundAt(world, null, pos);
            handleServerParticlesAt(world, null, pos);
        });

    }
    public void doActionServer(class_3218 world, class_1297 owner) {
        DatapackUtils.ScheduleForNextTick((s) -> {
            handleFunction(world, owner);
            handleServerSound(world, owner);
            handleServerParticles(world, owner);
        });
    }
    public void doActionServerAt(class_3218 world, class_1297 owner, class_243 pos) {
        DatapackUtils.ScheduleForNextTick((s) -> {
            handleFunctionAt(world, owner, pos);
            handleServerSoundAt(world, owner, pos);
            handleServerParticlesAt(world, owner, pos);
        });

    }
    @SuppressWarnings("UnusedReturnValue")
    public DPUEvent Deserialize(JsonObject object){
        if (object.has("function")) {
            this.function = new class_2960(object.get("function").getAsString());
        }
        this.serverOnly = class_3518.method_15258(object, "onlyExecuteOnServer", false);
        this.requiredTickDelay = class_3518.method_15282(object, "delayBetweenEvents", 10);
        if (object.has("sound")) {
            JsonObject soundObjectPart = object.getAsJsonObject("sound");
            this.sound = class_3414.method_47908(class_2960.method_12829(soundObjectPart.get("id").getAsString()));
            this.SoundPitch = class_3518.method_15277(soundObjectPart, "pitch", 1f);
            this.SoundVolume = class_3518.method_15277(soundObjectPart, "volume", 1f);
        }
        if (object.has("particle")) {
            JsonObject pObjectPart = object.getAsJsonObject("particle");
            this.particle = class_7923.field_41180.method_10223(new class_2960(pObjectPart.get("id").getAsString()));
            JsonArray pOffsetPart = class_3518.method_15292(pObjectPart, "offset", DESERIALIZE_OFFSET_ZERO);
            this.ParticleOffset = new class_243(pOffsetPart.get(0).getAsDouble(), pOffsetPart.get(1).getAsDouble(), pOffsetPart.get(2).getAsDouble());
        }

        return this;
    }
}
