package com.feintha.dpu;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.resource.*;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.*;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

@SuppressWarnings("unused")
public class alib {

    public static <F,T> F getMixinField(T mixinType, String fieldName) {
        try {
            Field f = mixinType.getClass().getField(fieldName);
            //noinspection unchecked
            return (F) f.get(mixinType);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
    public static <F,T> F setMixinField(T mixinType, String fieldName, F value) {
        try {
            Field f = mixinType.getClass().getField(fieldName);
            f.set(mixinType, value);
            //noinspection unchecked
            return (F)f.get(mixinType);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
    public static <F,T> F setPrivateMixinField(T mixinType, String fieldName, F value) {
        try {
            Field f = mixinType.getClass().getField(fieldName);
            f.setAccessible(true);
            f.set(mixinType, value);
            //noinspection unchecked
            return (F)f.get(mixinType);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
    public static <F,T> F getPrivateMixinField(T mixinType, String fieldName) {
        try {
            Field f = mixinType.getClass().getDeclaredField(fieldName);
            //noinspection unchecked
            return (F) f.get(mixinType);
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
    public static <T, R> R runMixinMethod(T mixinType, String methodName, Object ... args) {
        try {
            Method f = mixinType.getClass().getMethod(methodName);
            //noinspection unchecked
            return (R) f.invoke(mixinType, args);
        } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
    public static <T> void runPrivateMixinMethod(T mixinType, String methodName, Object args) {
        try {
            Method f = mixinType.getClass().getDeclaredMethod(methodName);
            f.invoke(mixinType);
        } catch (NoSuchMethodException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
    public static float getRandomFloat(class_5819 random, float minValue, float maxValue) {
        return minValue + random.method_43057() * (maxValue - minValue);
    }
    public static <T extends class_1297> List<T> getEntitiesOfTypeInRange(class_1937 world, class_2338 pos, double range, class_1299<T> type) {
        Predicate<class_1297> filter = entity -> entity.method_5864() == type && entity.method_5649(pos.method_10263(), pos.method_10264(), pos.method_10260()) <= range * range;
        return world.method_18023(type, class_238.method_30048(class_243.method_24954(pos),range, range, range), filter);
    }
    public static boolean isEntityNearBlock(class_1297 e, int radius, class_2248... blocks) {
        // Get the entity's position
        class_2338 entityPos = e.method_24515();

        // Check if any nearby block is a target block type
        for (int x = -radius; x <= radius; x++) {
            for (int y = -radius; y <= radius; y++) {
                for (int z = -radius; z <= radius; z++) {
                    class_2338 pos = entityPos.method_10069(x, y, z);
                    class_2248 block = e.field_6002.method_8320(pos).method_26204();
                    for (class_2248 b : blocks) {
                        System.out.println("check");
                        if (block == b) {
                            return true;
                        }
                    }
                }
            }
        }

        // No nearby block is a target block type
        return false;
    }
    /**
     * Calculate a 64 bits hash by combining CRC32 with Adler32.
     *
     * @param bytes a byte array
     * @return a hash number
     */
    public static long getHash64(byte[] bytes) {

        CRC32 crc32 = new CRC32();
        Adler32 adl32 = new Adler32();

        crc32.update(bytes);
        adl32.update(bytes);

        long crc = crc32.getValue();
        long adl = adl32.getValue();
        return ((crc << 32) | adl) + crc << 8;
    }
    public static boolean stackCustomModelDataEquals(@NotNull class_1799 stack, int data) {
        if (!stack.method_7948().method_10545("CustomModelData")) {return false;}
        return stack.method_7948().method_10550("CustomModelData") == data;
    }
    public static long getHash64(String s) {
        return getHash64(s.getBytes(StandardCharsets.UTF_8));
    }
    public static long bitenable(long var, long nbit) {
        return (var) |= (1L <<(nbit));
    }
    public static long bitdisable(long var, long nbit) {
        return (var) &= (1L <<(nbit));
    }
    public static long bitflip(long var, long nbit) {
        return (var) ^= (1L <<(nbit));
    }
    public static boolean getbit(long var, long nbit) {
        return ((var) & (1L <<(nbit))) == 1;
    }
    public static long setbit(long var, long nbit, boolean value) {
        if (value) {
            return bitenable(var, nbit);
        } else {
            return bitdisable(var,nbit);
        }
    }
    public static boolean isBlockIn(class_2680 source, class_6862<class_2248> tag) {
        return source.method_26164(tag);
    }
    public static List<Pair<class_2960, class_2248>> GetAllBlocksInTag(class_6862<class_2248> tag) {
        List<Pair<class_2960, class_2248>> data = new ArrayList<>();
        Optional<class_6885.class_6888<class_2248>> init_BLOCKS = class_7923.field_41175.method_40266(tag);
        init_BLOCKS.ifPresent(registryEntries -> registryEntries.forEach(entry -> {
            class_2960 id = entry.method_40230().get().method_29177();
            class_2248 block = entry.comp_349();
            data.add(Pair.of(id,block));
        }));
        return data;
    }
    public static List<Pair<class_2960, class_2248>> GetAllBlocksInTagAnd(class_6862<class_2248> tag, Consumer<Pair<class_2960, class_2248>> onFound) {
        List<Pair<class_2960, class_2248>> data = new ArrayList<>();
        Optional<class_6885.class_6888<class_2248>> init_BLOCKS = class_7923.field_41175.method_40266(tag);
        init_BLOCKS.ifPresent(registryEntries -> registryEntries.forEach(entry -> {
            class_2960 id = entry.method_40230().get().method_29177();
            class_2248 block = entry.comp_349();
            data.add(Pair.of(id,block));
            onFound.accept(Pair.of(id,block));
        }));
        return data;
    }
    public static class_2338 getBlockPosFromArray(long[] a) {
        if (a.length < 3) {return class_2338.field_10980;}
        return new class_2338((int)a[0], (int)a[1], (int)a[2]);
    }
    public static long[] getBlockPosAsArray(class_2338 d) {
        if (d == null) {return new long[]{0, 0, 0};}
        return new long[]{d.method_10263(), d.method_10264(), d.method_10260()};
    }
    public static double[] getVec3dAsArray(class_243 d) {
        if (d == null) {return new double[]{0d, 0d, 0d};}
        return new double[]{d.method_10216(), d.method_10214(), d.method_10215()};
    }
    public static Class<?> getFunctionTemplateClass(Object object, int index) {
        Type genericInterface = object.getClass().getGenericInterfaces()[0];
        if (genericInterface instanceof ParameterizedType parameterizedType) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (index >= 0 && index < typeArguments.length) {
                return (Class<?>) typeArguments[index];
            }
        }
        throw new IllegalArgumentException("Index out of bounds or template not found.");
    }
    public static Pair<Integer, Integer> XYPosFromOffset(int w, int offset) {
        assert w != 0;
        int x;
        int y;
        x = offset % w;    // % is the "modulo operator", the remainder of i / width;
        assert offset != 0;
        y = offset / w;    // where "/" is an integer division
        return Pair.of(x,y);
    }
    public static double lerp(double a, double b, float f) {
        return a + f * (b - a);
    }
    public static int mixRGB (int a, int b, float ratio) {
        if (ratio > 1f) {
            ratio = 1f;
        } else if (ratio < 0f) {
            ratio = 0f;
        }
        float iRatio = 1.0f - ratio;

        int aA = (a >> 24 & 0xff);
        int aR = ((a & 0xff0000) >> 16);
        int aG = ((a & 0xff00) >> 8);
        int aB = (a & 0xff);

        int bA = (b >> 24 & 0xff);
        int bR = ((b & 0xff0000) >> 16);
        int bG = ((b & 0xff00) >> 8);
        int bB = (b & 0xff);

        int A = (int)((aA * iRatio) + (bA * ratio));
        int R = (int)((aR * iRatio) + (bR * ratio));
        int G = (int)((aG * iRatio) + (bG * ratio));
        int B = (int)((aB * iRatio) + (bB * ratio));

        return A << 24 | R << 16 | G << 8 | B;
    }
}
