package com.feintha.dpu.client;

import com.feintha.dpu.DPU;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_811;

public class DatapackUtilsClient implements ClientModInitializer {
    /**
     * Runs the mod initializer on the client environment.
     */
    public static int worldTick, clientTick;
    @Override
    public void onInitializeClient() {
        DPU.InitEverything();

        class_5272.method_27881(new class_2960("is_hand_first"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInHandFirst(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_hand_third"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInHandThird(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_hand_any"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInHandAny(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_gui"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInGUI(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_inventory"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInGUI(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_fixed"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInFixedPos(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_dropped"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingAsDropped(itemStack);
        }));
        class_5272.method_27881(new class_2960("is_hotbar"), new BooleanModelOverride((itemStack, clientWorld, livingEntity, integer) -> {
            return BooleanModelOverride.isRenderingInHotbar(itemStack);
        }));
        class_5272.method_27881(new class_2960("use_time"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0F;
            } else {
                return entity.method_6030() != stack ? 0.0F : (float)(stack.method_7935() - entity.method_6014()) / 20.0F;
            }
        });
        class_5272.method_27881(new class_2960("is_using"), (stack, world, entity, seed) -> {
            return entity != null && entity.method_6115() && entity.method_6030() == stack ? 0.07991f : 0.0F;
        });
        class_5272.method_27881(new class_2960("is_swinging"), (stack, world, entity, seed) -> {
            return entity != null && entity.field_6252 && entity.method_6030() == stack ? 0.07991f : 0.0F;
        });
        class_5272.method_27881(new class_2960("is_attacking"), (stack, world, entity, seed) -> {
            return entity != null && entity.field_6252 && entity.method_6030() == stack ? 0.07991f : 0.0F;
        });

        ClientTickEvents.END_WORLD_TICK.register(world -> {
            worldTick++;
        });
        ClientTickEvents.END_CLIENT_TICK.register(world -> {
            clientTick++;
        });
        DPU.InitClientEvents();
    }
    public static boolean isModelTransformationInHand(class_811 mode) {
        return mode.method_29998() || mode == class_811.field_4323 || mode == class_811.field_4320;
    }
    public static boolean isModelTransformationFixed(class_811 mode) {
        return mode == class_811.field_4319;
    }
    public static boolean isModelTransformationGui(class_811 mode) {
        return mode == class_811.field_4317;
    }
    public static boolean isModelTransformationInHandFirst(class_811 mode) {
        return mode.method_29998();
    }
    public static boolean isModelTransformationInHandThird(class_811 mode) {
        return mode == class_811.field_4323 || mode == class_811.field_4320;
    }

}
