package com.feintha.dpu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2203;
import net.minecraft.class_2232;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class StringCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access){
        dispatcher.register(class_2170.method_9247("string").then(class_2170.method_9247("equals")
                .then(class_2170.method_9247("storage").then(class_2170.method_9244("location", class_2232.method_9441()).then(class_2170.method_9244("path", class_2203.method_9360()).then(class_2170.method_9244("str",StringArgumentType.string()).executes(StringCommand::string_equals_storage)))))
                .then(class_2170.method_9247("entity").then(class_2170.method_9244("entity", class_2186.method_9309()).then(class_2170.method_9244("path", class_2203.method_9360()).then(class_2170.method_9244("str",StringArgumentType.string()).executes(StringCommand::string_equals_entity)))))
        ));
    }
    private static int string_equals_storage(CommandContext<class_2168> context) {
        class_2960 location = class_2232.method_9443(context, "location");
        class_2203.class_2209 path = class_2203.method_9358(context, "path");
        String chk = StringArgumentType.getString(context, "str");
        var loc_data = context.getSource().method_9211().method_22827().method_22546(location);
        if (loc_data == null) {
            context.getSource().method_9213(class_2561.method_43470("Location " + location + " was not found."));
            return 0;
        }
        if (loc_data.method_33133()) {return 0;}
        try {
            var p = path.method_9366(loc_data);
            if (p.size() > 0) {
                String s = p.stream().findFirst().get().method_10714();
                System.out.println(s +" == " + chk);
                return s.contentEquals(chk) ? 1 : 0;
            }
        } catch (CommandSyntaxException e) {
            context.getSource().method_9213(class_2561.method_43470("Something went wrong when trying to read!"));
        }


        return 0;

    }
    private static int string_equals_entity(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 location = class_2186.method_9313(context, "entity");
        class_2203.class_2209 path = class_2203.method_9358(context, "path");
        String chk = StringArgumentType.getString(context, "str");
        class_2487 loc_data = new class_2487();
        location.method_5647(loc_data);
        if (loc_data.method_33133()) {return 0;}
        try {
            var p = path.method_9366(loc_data);
            if (p.size() > 0) {
                String s = p.stream().findFirst().get().method_10714();
                System.out.println(s +" == " + chk);
                return s.contentEquals(chk) ? 1 : 0;
            }
        } catch (CommandSyntaxException e) {
            context.getSource().method_9213(class_2561.method_43470("Something went wrong when trying to read!"));
        }


        return 0;

    }
}
