package com.feintha.dpu.mixin;

import com.feintha.dpu.DPU;
import com.feintha.dpu.DPUDataStorage;
import com.feintha.dpu.DPUEventType;
import com.feintha.dpu.alib;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4970.class)
public class AbstractBlockMixin {
    @Inject(method="onUse", at=@At("TAIL"))
    private void onUseMixin(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, CallbackInfoReturnable<class_1269> cir){
        class_2960 id = class_7923.field_41175.method_10221(state.method_26204());
        if (world.field_9236) {
            DPU.InvokeClientEventForAt(DPUEventType.ON_INTERACT_BLOCK_EVENT, id, hit.method_17784());
        } else {

            class_2487 compound = new class_2487();
            compound.method_10582("type", id.toString());
            compound.method_10564("blockpos", alib.getBlockPosAsArray(pos));
            compound.method_10582("side", hit.method_17780().method_10151());
            compound.method_10582("item", class_7923.field_41178.method_10221(player.method_5998(hand).method_7909()).toString());
            assert world.method_8503() != null;
            DPUDataStorage.PushEvent(world.method_8503(), "block_use", compound);
            DPU.InvokeServerEventForAt(DPUEventType.ON_INTERACT_BLOCK_EVENT, id, hit.method_17784(), (class_3218)world, player);
        }
    }
    @Inject(method="onStateReplaced", at=@At("TAIL"))
    void blockBrokenMixin(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved, CallbackInfo ci) {
        // Assume this means the block was broken.
        if (newState.method_26215()) {
            class_2960 id = class_7923.field_41175.method_10221(state.method_26204());
            if (world.field_9236) {
                DPU.InvokeClientEventForAt(DPUEventType.ON_INTERACT_BLOCK_EVENT, id, pos.method_46558());
            } else {
                class_2487 compound = new class_2487();
                compound.method_10582("type", id.toString());
                compound.method_10564("blockpos", alib.getBlockPosAsArray(pos));
                assert world.method_8503() != null;
                DPUDataStorage.PushEvent(world.method_8503(), "block_broken", compound);
                DPU.InvokeServerEventForAt(DPUEventType.ON_INTERACT_BLOCK_EVENT, id, pos.method_46558(), (class_3218)world, null);
            }
        }
    }
}
