package com.feintha.dpu.mixin;

import com.feintha.dpu.DPU;
import com.feintha.dpu.DPUDataStorage;
import com.feintha.dpu.DPUEventType;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public class EntityMixin {
    @Inject(method="collidesWith", at=@At("RETURN"))
    void collidesWithInject(class_1297 other, CallbackInfoReturnable<Boolean> cir) {
        class_1297 e = (class_1297) (Object)this;
        class_2960 myid = class_7923.field_41177.method_10221(e.method_5864());
        class_2960 otherid = class_7923.field_41177.method_10221(other.method_5864());
        class_2960 id = new class_2960(myid.method_12836(), myid.method_12832() + "_" + otherid.method_12832());
        if (other.field_6002.field_9236){
            DPU.InvokeClientEventForAt(DPUEventType.ON_ENTITY_COLLIDE_EVENT, id, e.method_19538());
        } else {
            class_2487 compound = new class_2487();
            compound.method_10582("source_type", myid.toString());
            compound.method_10582("source_name", e.method_5477().getString());
            compound.method_10582("target_type", otherid.toString());
            compound.method_10582("target_name", other.method_5477().getString());
            compound.method_25927("uuid", e.method_5667());
            DPUDataStorage.PushEvent(other.field_6002.method_8503(), "entity_collide", compound);
            DPU.InvokeServerEventForAt(DPUEventType.ON_ENTITY_COLLIDE_EVENT, id, e.method_19538(), (class_3218) e.field_6002, e);
        }

    }
    @Inject(method="interactAt", at=@At("TAIL"))
    void useAtInject(class_1657 player, class_243 hitPos, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1297 e = (class_1297) (Object)this;
        class_2960 id = class_7923.field_41177.method_10221(e.method_5864());
        System.out.println(id);
        if (player.field_6002.field_9236){
            DPU.InvokeClientEventForAt(DPUEventType.ON_INTERACT_ENTITY_EVENT, id, hitPos);
        } else {
            assert player.field_6002.method_8503() != null;
            class_2487 compound = new class_2487();
            compound.method_10582("type", id.toString());
            compound.method_10582("name", e.method_5477().getString());
            compound.method_25927("uuid", e.method_5667());
            DPUDataStorage.PushEvent(player.field_6002.method_8503(), "entity_interact", compound);
            DPU.InvokeServerEventForAt(DPUEventType.ON_INTERACT_ENTITY_EVENT, id, hitPos, (class_3218)player.field_6002, player);
        }
    }
    @Inject(method="handleAttack", at=@At("TAIL"))
    void attackInject(class_1297 attacker, CallbackInfoReturnable<Boolean> cir) {
        if (!attacker.method_31747()){return;}
        class_1297 e = (class_1297) (Object)this;
        class_2960 id = class_7923.field_41177.method_10221(e.method_5864());
        System.out.println(id);
        if (attacker.field_6002.field_9236){
            DPU.InvokeClientEventFor(DPUEventType.ON_ATTACK_ENTITY_EVENT, id);
        } else {
            assert attacker.field_6002.method_8503() != null;
            class_2487 compound = new class_2487();
            compound.method_10582("type", id.toString());
            compound.method_10582("name", e.method_5477().getString());
            compound.method_25927("uuid", e.method_5667());
            DPUDataStorage.PushEvent(attacker.field_6002.method_8503(), "entity_attack", compound);
            DPU.InvokeServerEventForAt(DPUEventType.ON_ATTACK_ENTITY_EVENT, id, e.method_33571(), (class_3218)attacker.field_6002, null);
        }
    }

}
