package com.feintha.dpu.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_799;

@Mixin(targets = "net.minecraft.client.render.model.json.ModelOverride$Deserializer")
public class ModelLoaderDeserializerMixin {
    @Inject(method="deserializeMinPropertyValues", at=@At("HEAD"), cancellable = true)
    private void onDeserializeMinPropertyValues(JsonObject object, CallbackInfoReturnable<List<class_799.class_5826>> cir) {
        Map<class_2960, Float> map = Maps.newLinkedHashMap();
        JsonObject jsonObject = class_3518.method_15296(object, "predicate");
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : jsonObject.entrySet()) {
            if (class_3518.method_34921(stringJsonElementEntry.getValue())) {
                boolean s = class_3518.method_15268(stringJsonElementEntry.getValue(), stringJsonElementEntry.getKey());
                float v = s ? 0.07991f : 0;
                map.put(new class_2960(stringJsonElementEntry.getKey()), v);
                continue;
            }
            map.put(new class_2960(stringJsonElementEntry.getKey()), class_3518.method_15269(stringJsonElementEntry.getValue(), stringJsonElementEntry.getKey()));
        }
        cir.setReturnValue (map.entrySet().stream().map((entry) -> new class_799.class_5826(entry.getKey(), entry.getValue())).collect(ImmutableList.toImmutableList()));
    }
}
