package com.feintha.dpu.mixin;

import com.feintha.dpu.*;
import com.feintha.dpu.Events.DPUPlayerEvent;
import com.feintha.dpu.client.DatapackUtilsClient;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public class PlayerEntityMixin {
    int lastJumpTick = 0;
    @Inject(method="jump", at=@At("TAIL"))
    public void setJumping(CallbackInfo ci) {
        class_1657 _this = (class_1657)(Object)this;
        if (_this.field_6002.field_9236) {
            var evs = DPU.getAllClientEventsFor(DPUEventType.ON_JUMP);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutPlayerData(_this);
                }
                ev.doActionClientAt(_this.method_19538());
            }
            lastJumpTick = DatapackUtilsClient.worldTick;
        } else {
            var evs = DPU.getAllServerEventsFor(DPUEventType.ON_JUMP);
            System.out.println(evs.size());
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutPlayerData(_this);
                }
                ev.doActionServerAt((class_3218) _this.field_6002, _this, _this.method_19538());
            }
            lastJumpTick = _this.field_6002.method_8503().method_3780();
        }
    }
    void exec(class_1657 _this, DPUEventType type) {
        if (_this.field_6002.field_9236) {
            var evs = DPU.getAllClientEventsFor(type);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutPlayerData(_this);
                }
                ev.doActionClientAt(_this.method_19538());
            }
        } else {
            var evs = DPU.getAllServerEventsFor(type);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutPlayerData(_this);
                }
                ev.doActionServerAt((class_3218) _this.field_6002, _this, _this.method_19538());
            }
        }
    }

    public void emitGameEvent(class_5712 event) {
        class_1657 _this = (class_1657) (Object) this;
        if (event == class_5712.field_28735) {
            exec(_this, DPUEventType.ON_EAT);
        }
        _this.field_6002.method_43275(_this, event, _this.method_19538());
    }
    boolean sneakLast = false;
    boolean shieldLast = false;
    @Inject(method="tick",at=@At("TAIL"))
    void tickInject(CallbackInfo ci) {
        class_1657 _this = (class_1657) (Object) this;
//        if (_this.isBlocking()) {
//            if (!shieldLast) {
//                exec(_this, DPUEventType.ON_SHIELD_RAISE);
//            } else {
//                exec(_this, DPUEventType.WHILE_SHIELD_RAISED);
//            }
//        } else if (shieldLast) {
//            exec(_this, DPUEventType.ON_SHIELD_LOWER);
//        }
        if (_this.method_5715()) {
            if (!sneakLast) {
                exec(_this, DPUEventType.ON_SNEAK);
            } else {
                exec(_this, DPUEventType.WHILE_SNEAK);
            }
        } else if (sneakLast) {
            exec(_this, DPUEventType.ON_SNEAK_END);
        }
        if (_this.field_6252 && _this.field_6279 == 0) {
            class_2960 id = class_7923.field_41178.method_10221(_this.method_6047().method_7909());
            if (_this.field_6002.field_9236) {
                DPU.InvokeClientEventFor(DPUEventType.ON_SWING_EVENT, id);
            } else {
                DPU.InvokeServerEventFor(DPUEventType.ON_SWING_EVENT, id, (class_3218) _this.field_6002, _this);
            }
        }
        sneakLast = _this.method_5715();
    }
}
