package com.feintha.dpu;

import com.feintha.dpu.Events.DPUPlayerEvent;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.impl.client.rendering.EntityRendererRegistryImpl;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;

public class DPU {

    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_PROP = 0;
    public static final int VERSION_MINOR = 2;
    public static final int VERSION_ID = (100*VERSION_MAJOR) + (10*VERSION_PROP) + (VERSION_MINOR);
    public static class DPUWorkerThread_T extends Thread{
        public DPUWorkerThread_T(int id) {
            super("DPUWorkerThread" + id);
        }
        public Function<Object, Object> currentMethod;
        public Object data;
        private boolean completed = false;
        public boolean isCompleted() { return completed; }
        public boolean isBusy() { return !completed; }

        @Override
        public void run() {
            super.run();
            completed = false;
            currentMethod.apply(data);
            completed = true;
        }
    }
    public static ThreadPoolExecutor DPUWorkerThreads;
    public static final class_5321<class_2378<DPUEventType>> EVENT_TYPE_KEYS = class_5321.method_29180(new class_2960("dpu", "eventtypes"));
    public static final class_2378<DPUEventType> EVENT_TYPE = FabricRegistryBuilder.createSimple(EVENT_TYPE_KEYS).buildAndRegister();
    public static void InitEverything() {
        DPUEventType._MINIT();
        for (var entry : EVENT_TYPE.method_29722()) {
            entry.getValue().Events.clear();
        }
        DPUWorkerThreads = (ThreadPoolExecutor) Executors.newFixedThreadPool(8);
    }
    public static boolean InvokeClientEventFor(DPUEventType type, class_2960 idToRun) {
        class_2960 id = new class_2960("cl_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("cl_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            cancel = action.doActionClient(false);
        }
        if (actionS != null) {
            cancel |= actionS.doActionClient(false);
        }
        return cancel;
    }
    public static <T> boolean InvokeClientEventFor(DPUEventType type, class_2960 idToRun, T data) {
        class_2960 id = new class_2960("cl_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("cl_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            cancel = action.doActionClient(false, data);
        }
        if (actionS != null) {
            cancel |= actionS.doActionClient(false, data);
        }
        return cancel;
    }
    public static boolean InvokeServerEventFor(DPUEventType type, class_2960 idToRun, class_3218 world, @NotNull class_1297 owner, boolean immediate) {
        class_2960 id = new class_2960("sv_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("sv_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            action.putEventData(owner,world,world.method_8503(), id);
            cancel = action.doActionServer(world, owner, immediate);
        }
        if (actionS != null) {
            actionS.putEventData(owner,world,world.method_8503(), id);
            cancel |= actionS.doActionServer(world,owner, immediate);
        }
        return cancel;
    }
    public static boolean InvokeClientEventForAt(DPUEventType type, class_2960 idToRun, class_243 pos) {
        class_2960 id = new class_2960("cl_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("cl_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            cancel = action.doActionClientAt(pos, false);
        }
        if (actionS != null) {
            cancel |= actionS.doActionClientAt(pos, false);
        }
        return cancel;
    }
    public static boolean InvokeServerEventForAt(DPUEventType type, class_2960 idToRun, class_243 pos, class_3218 world, class_1297 owner) {
        class_2960 id = new class_2960("sv_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("sv_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            action.putEventData(owner,world,world.method_8503(), id);
            cancel = action.doActionServerAt(world, owner, pos, false);
        }
        if (actionS != null) {
            actionS.putEventData(owner,world,world.method_8503(), id);
            cancel |= actionS.doActionServerAt(world,owner, pos, false);
        }
        return cancel;
    }



    public static <T>boolean InvokeServerEventFor(DPUEventType type, class_2960 idToRun, class_3218 world, @NotNull class_1297 owner, boolean immediate, T data) {
        class_2960 id = new class_2960("sv_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("sv_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            action.putEventData(owner,world,world.method_8503(), id);
            cancel = action.doActionServer(world, owner, immediate, data);
        }
        if (actionS != null) {
            actionS.putEventData(owner,world,world.method_8503(), id);
            cancel |= actionS.doActionServer(world,owner, immediate, data);
        }
        return cancel;
    }
    public static <T>boolean InvokeClientEventForAt(DPUEventType type, class_2960 idToRun, class_243 pos, T data) {
        class_2960 id = new class_2960("cl_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("cl_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            cancel = action.doActionClientAt(pos, true, data);
        }
        if (actionS != null) {
            cancel |= actionS.doActionClientAt(pos, true, data);
        }
        return cancel;
    }
    public static <T>boolean InvokeServerEventForAt(DPUEventType type, class_2960 idToRun, class_243 pos, class_3218 world, class_1297 owner, T data) {
        class_2960 id = new class_2960("sv_"+idToRun.method_12836(), idToRun.method_12832());
        class_2960 idStar = new class_2960("sv_"+idToRun.method_12836(), "--");
        DPUEvent action = type.getSubEvent(id);
        DPUEvent actionS = type.getSubEvent(idStar);
        boolean cancel = false;
        if (action != null) {
            action.putEventData(owner,world,world.method_8503(), id);
            cancel = action.doActionServerAt(world, owner, pos, false, data);
        }
        if (actionS != null) {
            actionS.putEventData(owner,world,world.method_8503(), id);
            cancel |= actionS.doActionServerAt(world,owner, pos, false, data);
        }
        return cancel;
    }




    public static void InitClientEvents() {
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return new class_2960("feintha", "dpu_resource_pack_listener");
            }
            final String SIDE = "cl_";
            final String r_M = "\\/([A-Za-z0-9_.-]+)\\.json";
            @Override
            public void method_14491(class_3300 manager) {
//                var entityRendererFactories = alib.<Map<EntityType<?>, EntityRendererFactory<?>>,EntityRenderers>getPrivateMixinField(null, "RENDERER_FACTORIES");
//                entityRendererFactories.forEach((entityType, entityRendererFactory) -> {
////                    entityRendererFactory.create()
//                });

                int l = 0;
                for (var entry : EVENT_TYPE.method_29722()) {
                    class_2960 __id = entry.getKey().method_29177();
                    String _path = "events/" + __id.method_12832();
                    var on_use_files = manager.method_14488(_path, path -> path.method_12832().endsWith(".json"));
                    for (var id : on_use_files.keySet()) {
                        var file = on_use_files.get(id);
                        String itemName = id.method_12832().replaceAll(".*/(.*?)\\.json", "$1");
                        class_2960 itemID = new class_2960(id.method_12836(), itemName);
                        class_2960 registryID = new class_2960(SIDE+itemID.method_12836(), itemID.method_12832());
                        try {
                            String input = new String(file.method_14482().readAllBytes(), StandardCharsets.UTF_8);
                            var j = new JsonParser().parse(input);
                            entry.getValue().addSubEvent(registryID, entry.getValue().createEventType(new JsonParser().parse(input)));
                            l++;
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                System.out.println("Loaded " + l + " server-side events.");
            }
        });
    }
    public static void InitCustomBlocks() {
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public void method_14491(class_3300 manager) {
                String _path = "custom/blocks/";
                var custom_block_files = manager.method_14488(_path, path -> path.method_12832().endsWith(".json"));
                custom_block_files.forEach((identifier, resource) -> {

                });
            }

            @Override
            public class_2960 getFabricId() {
                return new class_2960("dpu", "blocks");
            }
        });

    }
    public static void InitServerEvents() {
        ServerTickEvents.START_SERVER_TICK.register(world -> {
            if (world.method_3780() <= 1) {
                DPUDataStorage.InitServer(world);
            }
        });
        ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return new class_2960("feintha", "dpu_data_pack_listener");
            }

            final String r_M = "\\/([A-Za-z0-9_.-]+)\\.json";
            final String SIDE = "sv_";
            @Override
            public void method_14491(class_3300 manager) {
                int l = 0;
                for (var entry : EVENT_TYPE.method_29722()) {
                    class_2960 __id = entry.getKey().method_29177();
                    String _path = "events/" + __id.method_12832();
                    var on_use_files = manager.method_14488(_path, path -> path.method_12832().endsWith(".json"));
                    for (var id : on_use_files.keySet()) {
                        var file = on_use_files.get(id);
                        String itemName = id.method_12832().replaceAll(".*/(.*?)\\.json", "$1");
                        class_2960 itemID = new class_2960(id.method_12836(), itemName);
                        class_2960 registryID = new class_2960(SIDE+itemID.method_12836(), itemID.method_12832());
                        try {
                            String input = new String(file.method_14482().readAllBytes(), StandardCharsets.UTF_8);
                            entry.getValue().addSubEvent(registryID, entry.getValue().createEventType(new JsonParser().parse(input)));
                            l++;
                        } catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                System.out.println("Loaded " + l + " server-side events.");
            }
        });
    }



    public static void InvokeAllClientEventsFor(DPUEventType type) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("cl_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionClient(false);
                }
            }
        }
    }
    public static void InvokeAllServerEventsFor(DPUEventType type, class_3218 world, @NotNull class_1657 owner, boolean immediate) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("sv_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionServer(world, owner, immediate);
                }
            }
        }
    }
    public static Collection<DPUEvent> getAllClientEventsFor(DPUEventType type) {
        ArrayList<DPUEvent> ev = new ArrayList<>();
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("cl_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    ev.add(action);
                }
            }
        }
        return ev;
    }
    public static Collection<DPUEvent> getAllServerEventsFor(DPUEventType type) {
        ArrayList<DPUEvent> ev = new ArrayList<>();
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("sv_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    ev.add(action);
                }
            }
        }
        return ev;
    }
    public static void InvokeAllClientEventsForAt(DPUEventType type, class_243 pos) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("cl_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionClientAt(pos, false);
                }
            }
        }
    }
    public static void InvokeAllServerEventsForAt(DPUEventType type, class_3218 world, @NotNull class_1657 owner, class_243 pos) {
        for (var ev_id : type.Events.keySet()) {
            if (ev_id.toString().startsWith("sv_")) {
                DPUEvent action = type.getSubEvent(ev_id);
                if (action != null) {
                    action.doActionServerAt(world, owner, pos, false);
                }
            }
        }
    }


}
