package com.feintha.dpu;

import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.nbt.*;
import net.minecraft.server.MinecraftServer;

public class DPUDataStorage {
    public static class_2487 EventCompound = new class_2487();
    public static class_2487 CommandReturnsCompound = new class_2487();
    public static class_2487 CommandArgumentsCompound = new class_2487();
    public static class_2487 VariablesCompound = new class_2487();
    public static void InitServer(MinecraftServer s) {
        s.method_22827().method_22547(new class_2960("dpu", "events"), EventCompound);
    }
    public static void PopEvent(MinecraftServer s){
        for (var key : EventCompound.method_10541()) {
            EventCompound.method_10551(key);
        }
    }
    public static void PopReturns(MinecraftServer s){
        for (var key : CommandReturnsCompound.method_10541()) {
            CommandReturnsCompound.method_10551(key);
        }
    }
    public static void PopArgs(MinecraftServer s){
        for (var key : CommandArgumentsCompound.method_10541()) {
            CommandArgumentsCompound.method_10551(key);
        }
    }
    public static void PopVars(MinecraftServer s){
        for (var key : VariablesCompound.method_10541()) {
            VariablesCompound.method_10551(key);
        }
    }
    public static void PopEverything(MinecraftServer s) {
        PopArgs(s);
        PopEvent(s);
        PopReturns(s);
        PopVars(s);
    }
    public static void PushEvent(MinecraftServer s, String id, class_2520 compound) {
        PopEvent(s);
        EventCompound.method_10566(id, compound);
        s.method_22827().method_22547(new class_2960("dpu", "events"), EventCompound);
    }
    public static void PushCommandReturnVals(MinecraftServer s, String id, class_2520 compound) {
        PopReturns(s);
        CommandReturnsCompound.method_10566(id, compound);
        s.method_22827().method_22547(new class_2960("dpu", "returns"), CommandReturnsCompound);
    }
    public static void PushVariable(MinecraftServer s, String id, class_2487 compound) {
        PopEvent(s);
        VariablesCompound.method_10566(id, compound);
        s.method_22827().method_22547(new class_2960("dpu", "variable"), VariablesCompound);
    }
    public static class_2487 putValueF(class_2487 compound, float value) {
        compound.method_10548("float", value);
        return compound;
    }
    public static class_2487 putValueB(class_2487 compound, boolean value) {
        compound.method_10556("boolean", value);
        return compound;
    }
    public static class_2487 putValueL(class_2487 compound, long value) {
        compound.method_10544("long", value);
        return compound;
    }
    public static class_2487 putValueS(class_2487 compound, short value) {
        compound.method_10575("short", value);
        return compound;
    }
    public static class_2487 putValueD(class_2487 compound, double value) {
        compound.method_10549("double", value);
        return compound;
    }
    public static class_2487 putValueStr(class_2487 compound, String value) {
        compound.method_10582("string", value);
        return compound;
    }
    public static class_2487 putVec3d(class_2487 compound, class_243 vec3d) {
        class_2499 l = new class_2499();
        class_2520 e0 = class_2489.method_23241(vec3d.field_1352);
        class_2520 e1 = class_2489.method_23241(vec3d.field_1351);
        class_2520 e2 = class_2489.method_23241(vec3d.field_1350);
        l.add(e0);
        l.add(e1);
        l.add(e2);
        compound.method_10566("position", l);
        return compound;
    }
    public static class_2487 putFloats(class_2487 compound, float... floats) {
        class_2499 l = new class_2499();
        for (float _flt : floats) {
            l.add(class_2494.method_23244(_flt));
        }
        compound.method_10566("floats", l);
        return compound;
    }
    public static class_2487 putInts(class_2487 compound, int... floats) {
        class_2499 l = new class_2499();
        for (int _flt : floats) {
            l.add(class_2497.method_23247(_flt));
        }
        compound.method_10566("ints", l);
        return compound;
    }
    public static class_2487 putBools(class_2487 compound, boolean... floats) {
        class_2499 l = new class_2499();
        for (boolean _flt : floats) {
            l.add(class_2481.method_23234(_flt));
        }
        compound.method_10566("bools", l);
        return compound;
    }
    public static class_2487 putStrings(class_2487 compound, String... floats) {
        class_2499 l = new class_2499();
        for (String _flt : floats) {
            l.add(class_2519.method_23256(_flt));
        }
        compound.method_10566("strings", l);
        return compound;
    }
    public static class_2487 putBlockPos(class_2487 compound, class_2338 pos) {
        compound.method_10564("blockpos", alib.getBlockPosAsArray(pos));
        return compound;
    }
    public static class_2487 putCompound(class_2487 compound, class_2487 compoundToAdd) {
        compound.method_10566("nbt", compoundToAdd);
        return compound;
    }
    public static void PushCommandInputVals(MinecraftServer s, String id, class_2487 compound) {
        PopArgs(s);
        CommandArgumentsCompound.method_10566(id, compound);
        s.method_22827().method_22547(new class_2960("dpu", "arguments"), CommandArgumentsCompound);
    }
}
