package com.feintha.dpu;

import com.feintha.dpu.client.DatapackUtilsClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public abstract class DPUEvent {
    public boolean cancelEvent = false;
    public class_2960 function = null;
    public boolean serverOnly = false;
    public int actionLastTick = 0;
    public int requiredTickDelay = 0;

    public static JsonArray DESERIALIZE_OFFSET_ZERO = new JsonArray();
    static {
        DESERIALIZE_OFFSET_ZERO.add(0);
        DESERIALIZE_OFFSET_ZERO.add(0);
        DESERIALIZE_OFFSET_ZERO.add(0);
    }
    List<DPUEvent> nestedEvents = new ArrayList<>();
    public class_3414 sound;

    @SuppressWarnings("rawtypes")
    public class_2396 particle;
    // Particle offset. Uses camera rotation.
    public class_243 ParticleOffset = new class_243(0,0,0);
    public float SoundVolume = 1f;
    public float SoundPitch = 1f;

    public DPUEvent(JsonElement o, Function<JsonElement,DPUEvent> constructor){
        this.constructor = constructor;
        if (o.isJsonObject()) {
            nestedEvents.add(Deserialize(o.getAsJsonObject()));
        } else if (o.isJsonArray()) {
            nestedEvents = DeserializeNested(o.getAsJsonArray());
        } else {
            System.err.println("Incorrect type of event object, expected array or object, got primitive.");
        }
    }
    public DPUEvent(String input, Function<JsonElement,DPUEvent> constructor){
        this(new JsonParser().parse(input).getAsJsonObject(), constructor);
    }
    public void putEventData(@Nullable class_1297 owner, class_1937 world, MinecraftServer server, class_2960 id) {}

    protected final void handleClientParticles(){
        assert class_310.method_1551().field_1687 != null;
        if (particle != null) {
            assert class_310.method_1551().field_1724 != null;
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            class_243 rot = class_310.method_1551().field_1724.method_5663();
            class_243 pOff = ParticleOffset.method_18806(rot).method_1019(pos);
            class_310.method_1551().field_1687.method_8406((class_2394) particle, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleClientParticlesAt(class_243 pos){
        assert class_310.method_1551().field_1687 != null;
        if (particle != null) {
            class_243 pOff = ParticleOffset.method_1019(pos);
            class_310.method_1551().field_1687.method_8406((class_2394) particle, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleServerParticles(class_3218 world, class_1297 owner){
        if (particle != null) {
            class_243 pos = owner.method_33571();
            class_243 rot = owner.method_5720();
            class_243 pOff = ParticleOffset.method_18806(rot).method_1019(pos);
            world.method_8466((class_2394) particle, true, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleServerParticlesAt(class_3218 world, class_1297 owner, class_243 pos){
        if (particle != null) {
            class_243 pOff = ParticleOffset.method_1019(pos);
            world.method_8466((class_2394) particle, true, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0, 0, 0);
        }
    }
    protected final void handleFunction(class_3218 world, class_1297 owner) {
        if (function != null) {
            var func = world.method_8503().method_3740().method_12905(function);
            if (func.isPresent()) {
                world.method_8503().method_3740().method_12904(func.get(), world.method_8503().method_3739().method_9232(owner));
            } else {
                System.out.println("Unable to execute function " + function + " when using event.");
            }
        }
    }
    protected final void handleFunctionAt(class_3218 world, class_1297 owner, class_243 pos) {
        if (function != null) {
            var func = world.method_8503().method_3740().method_12905(function);
            if (func.isPresent()) {
                world.method_8503().method_3740().method_12904(func.get(), world.method_8503().method_3739().method_9208(pos).method_9232(owner));
            } else {
                System.out.println("Unable to execute function " + function + " when using event.");
            }
        }
    }
    protected final void handleClientSound(){
        assert class_310.method_1551().field_1687 != null;
        if (sound != null) {
            // hacky solutions are sometimes the only solution :despair:
            assert class_310.method_1551().field_1724 != null;
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            class_310.method_1551().field_1687.method_8486(pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch, true);
        }
    }
    protected final void handleClientSoundAt(class_243 pos){
        assert class_310.method_1551().field_1687 != null;
        if (sound != null) {
            class_310.method_1551().field_1687.method_43128(null, pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch);
        }
    }
    protected final void handleServerSound(class_3218 w, class_1297 owner){
        if (sound != null) {
            class_243 pos = owner.method_33571();
            w.method_43128(null, pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch);
        }
    }
    protected final void handleServerSoundAt(class_3218 w, class_1297 owner, class_243 pos){
        if (sound != null) {
            w.method_43128(null, pos.field_1352, pos.field_1351 - 0.25f, pos.field_1350, sound, class_3419.field_15250, SoundVolume, SoundPitch);
        }
    }
    public boolean doActionClient(boolean immediate){
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSound();
                    e.handleClientParticles();
                });
            } else {
                e.handleClientSound();
                e.handleClientParticles();
            }
        }
        return c;
    }
    public boolean doActionClientAt(class_243 pos, boolean immediate){
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSoundAt(pos);
                    e.handleClientParticlesAt(pos);
                });
            } else {
                e.handleClientSoundAt(pos);
                e.handleClientParticlesAt(pos);
            }
        }
        return c;
    }
    public <T>boolean doActionClient(boolean immediate, T data){
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            if (!e.preProcessEvent(data)) {
                continue;
            }
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSound();
                    e.handleClientParticles();
                });
            } else {
                e.handleClientSound();
                e.handleClientParticles();
            }
        }
        return c;
    }
    public <T>boolean doActionClientAt(class_243 pos, boolean immediate, T data){
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            if (!e.preProcessEvent(data)) {
                continue;
            }
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSoundAt(pos);
                    e.handleClientParticlesAt(pos);
                });
                continue;
            }
            e.handleClientSoundAt(pos);
            e.handleClientParticlesAt(pos);
        }
        return c;
    }







    public <T>boolean doActionServerAt(class_3218 world, class_243 pos, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            if (!e.preProcessEvent(data)) {
                continue;
            }
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick((s) -> {
                    e.handleFunctionAt(world, null, pos);
                    e.handleServerSoundAt(world, null, pos);
                    e.handleServerParticlesAt(world, null, pos);
                });
                continue;
            }
            e.handleFunctionAt(world, null, pos);
            e.handleServerSoundAt(world, null, pos);
            e.handleServerParticlesAt(world, null, pos);
        }

        return c;
    }
    public boolean doActionServerAt(class_3218 world, class_243 pos, boolean immediate) {
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick((s) -> {
                    e.handleFunctionAt(world, null, pos);
                    e.handleServerSoundAt(world, null, pos);
                    e.handleServerParticlesAt(world, null, pos);
                });
            }
            e.handleFunctionAt(world, null, pos);
            e.handleServerSoundAt(world, null, pos);
            e.handleServerParticlesAt(world, null, pos);
        }
        return c;
    }
    public <T> boolean doActionServer(class_3218 world, class_1297 owner, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            if (!e.preProcessEvent(data)) {
                continue;
            }
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick((s) -> {
                    e.handleFunction(world, owner);
                    e.handleServerSound(world, owner);
                    e.handleServerParticles(world, owner);
                });
            }
            e.handleFunction(world, owner);
            e.handleServerSound(world, owner);
            e.handleServerParticles(world, owner);
        }
        return c;

    }
    public boolean doActionServer(class_3218 world, class_1297 owner, boolean immediate) {
        DatapackUtils.hasHadEvent = true;
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick((s) -> {
                    e.handleFunction(world, owner);
                    e.handleServerSound(world, owner);
                    e.handleServerParticles(world, owner);
                });
                continue;
            }
            e.handleFunction(world, owner);
            e.handleServerSound(world, owner);
            e.handleServerParticles(world, owner);
        }
        return c;
    }
    public <T>boolean doActionServerAt(class_3218 world, class_1297 owner, class_243 pos, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            c |= e.cancelEvent;
            if (!e.preProcessEvent(data)) {
                continue;
            }
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick((s) -> {
                    e.handleFunctionAt(world, owner, pos);
                    e.handleServerSoundAt(world, owner, pos);
                    e.handleServerParticlesAt(world, owner, pos);
                });
                continue;
            }
            e.handleFunctionAt(world, owner, pos);
            e.handleServerSoundAt(world, owner, pos);
            e.handleServerParticlesAt(world, owner, pos);
        }

        return c;
    }
    public boolean doActionServerAt(class_3218 world, class_1297 owner, class_243 pos, boolean immediate) {
        boolean c = false;
        for (DPUEvent e: nestedEvents) {
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick((s) -> {
                    e.handleFunctionAt(world, owner, pos);
                    e.handleServerSoundAt(world, owner, pos);
                    e.handleServerParticlesAt(world, owner, pos);
                });
            }
            e.handleFunctionAt(world, owner, pos);
            e.handleServerSoundAt(world, owner, pos);
            e.handleServerParticlesAt(world, owner, pos);
        }
        return c;
    }
    public class_2487 requiredNbt;
    public enum DPUDayType{
        MIDNIGHT, DAY, NIGHT
    }
    public <T> boolean preProcessEvent(T data) {
        System.out.println("default event type used");
        return true;
    }

    public final List<DPUEvent> DeserializeNested(JsonArray array) {
        List<DPUEvent> events = new ArrayList<>();
        for (JsonElement obj : array) {
            var elem = constructor.apply(obj);
            events.add(elem);
        }
        return events;
    }
    final Function<JsonElement, DPUEvent> constructor;
    @SuppressWarnings("UnusedReturnValue")
    public DPUEvent Deserialize(JsonObject object){
        if (object.has("predicate")) {
            JsonObject p_O = object.getAsJsonObject("predicate");
            if (p_O.has("nbt")) {
                JsonObject p_N = p_O.getAsJsonObject("nbt");
                requiredNbt = alib.json2NBT(p_N);
            }
        }
        if (object.has("cancels")) {
            this.cancelEvent = object.get("cancels").getAsBoolean();
        }
        if (object.has("function")) {
            this.function = new class_2960(object.get("function").getAsString());
        }
        this.serverOnly = class_3518.method_15258(object, "onlyExecuteOnServer", false);
        this.requiredTickDelay = class_3518.method_15282(object, "delayBetweenEvents", 10);
        if (object.has("sound")) {
            JsonObject soundObjectPart = object.getAsJsonObject("sound");
            this.sound = class_3414.method_47908(class_2960.method_12829(soundObjectPart.get("id").getAsString()));
            this.SoundPitch = class_3518.method_15277(soundObjectPart, "pitch", 1f);
            this.SoundVolume = class_3518.method_15277(soundObjectPart, "volume", 1f);
        }
        if (object.has("particle")) {
            JsonObject pObjectPart = object.getAsJsonObject("particle");
            this.particle = class_7923.field_41180.method_10223(new class_2960(pObjectPart.get("id").getAsString()));
            JsonArray pOffsetPart = class_3518.method_15292(pObjectPart, "offset", DESERIALIZE_OFFSET_ZERO);
            this.ParticleOffset = new class_243(pOffsetPart.get(0).getAsDouble(), pOffsetPart.get(1).getAsDouble(), pOffsetPart.get(2).getAsDouble());
        }

        return this;
    }
}
