package com.feintha.dpu;

import com.feintha.dpu.Events.*;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class DPUEventType {
    public static final DPUEventType ON_WORLD_BEGIN_RAINING = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_rain_begin"), new DPUEventType(DPUWorldEvent::new));
    public static final DPUEventType ON_WORLD_END_RAINING = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_rain_end"), new DPUEventType(DPUWorldEvent::new));
    public static final DPUEventType ON_WORLD_BEGIN_THUNDER = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_thunder_begin"), new DPUEventType(DPUWorldEvent::new));
    public static final DPUEventType ON_WORLD_END_THUNDER = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_thunder_end"), new DPUEventType(DPUWorldEvent::new));
    public static final DPUEventType RANDOM_WORLD_TICK = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("random_world_tick"), new DPUEventType(DPUWorldEvent.DPUWorldRandomEvent::new));
    public static final DPUEventType RANDOM_ENTITY_TICK = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("random_entity_tick"), new DPUEventType(DPUEntityEvent.DPUEntityRandomEvent::new));
    public static final DPUEventType ON_USE_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_use"), new DPUEventType(DPUItemEvent::new));
    public static final DPUEventType ON_ITEM_PICKUP_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_item_pickup"), new DPUEventType(DPUItemEvent::new));
    public static final DPUEventType ON_INTERACT_BLOCK_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_interact_block"), new DPUEventType(DPUBlockEvent::new));
    public static final DPUEventType ON_SWING_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_swing"), new DPUEventType(DPUItemEvent::new));
    public static final DPUEventType ON_ATTACK_ENTITY_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_attack_entity"), new DPUEventType(DPUEntityEvent::new));
    public static final DPUEventType ON_INTERACT_ENTITY_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_interact_entity"), new DPUEventType(DPUEntityEvent::new));
    public static final DPUEventType WHILE_SNEAK = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("while_sneak"), new DPUEventType(DPUPlayerEvent::new));
    public static final DPUEventType ON_SNEAK = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_sneak"), new DPUEventType(DPUPlayerEvent::new));
    public static final DPUEventType ON_SNEAK_END = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_sneak_end"), new DPUEventType(DPUPlayerEvent::new));
    public static final DPUEventType ON_JUMP = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_jump"), new DPUEventType(DPUPlayerEvent::new));
    public static final DPUEventType ON_EAT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_eat"), new DPUEventType(DPUPlayerEvent::new));
    public static final DPUEventType ON_ENTITY_COLLIDE_EVENT = class_2378.method_10230(DPU.EVENT_TYPE, new class_2960("on_collide_entity"), new DPUEventType(DPUEntityEvent::new));



//    public static final DPUEventType ON_SHIELD_RAISE = Registry.register(DPU.EVENT_TYPE, new Identifier("on_shield_raise"), new DPUEventType(DPUPlayerEvent::new));
//    public static final DPUEventType WHILE_SHIELD_RAISED = Registry.register(DPU.EVENT_TYPE, new Identifier("while_shield_raised"), new DPUEventType(DPUPlayerEvent::new));
//    public static final DPUEventType ON_SHIELD_LOWER = Registry.register(DPU.EVENT_TYPE, new Identifier("on_shield_lower"), new DPUEventType(DPUPlayerEvent::new));
    // Code to force Minecraft to load the registries here. Jank, I know, but it works.
    public static void _MINIT() {
        assert ON_USE_EVENT != null;
    }
    Function<JsonElement, ? extends DPUEvent> elementConsumer;
    DPUEventType(Function<JsonElement, ? extends DPUEvent> eventCtor) {
        elementConsumer = eventCtor;
    }
    public HashMap<class_2960, DPUEvent> Events = new HashMap<>();
    public DPUEvent getSubEvent(class_2960 eventName) {
        return Events.getOrDefault(eventName, null);
    }
    public <T extends DPUEvent> T createEventType(JsonElement arg){
        // noinspection unchecked
        return (T) elementConsumer.apply(arg);
    }
    public void addSubEvent (class_2960 eventName, DPUEvent event){
        Events.put(eventName, event);
    }
}
