package com.feintha.dpu.Events;

import com.feintha.dpu.DPUEvent;
import com.feintha.dpu.alib;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class DPUBlockEvent extends DPUEvent {
    class_2960 requiredItemID = new class_2960("minecraft", "air");

    public DPUBlockEvent(JsonElement o) {
        super(o, DPUBlockEvent::new);
    }

    @Override
    public <T> boolean preProcessEvent(T data) {
        if (this.requiredNbt != null && requiredNbt.method_10546() != 0) {
            if (data instanceof class_2680 s) {
                class_2487 c = new class_2487();
                alib.packBlockStateIntoCompound(s, c);
                return alib.checkNBTEquals(requiredNbt, c) && super.preProcessEvent(data);
            }
        }
        return super.preProcessEvent(data);
    }
    @Override
    public DPUEvent Deserialize(JsonObject object) {
        if (object.has("requiredItem")) {
            this.requiredItemID = new class_2960(object.get("requiredItem").getAsString());
        }
        return super.Deserialize(object);
    }
}
