package com.feintha.dpu.Events;

import com.feintha.dpu.DPUDataStorage;
import com.feintha.dpu.DPUEvent;
import com.feintha.dpu.alib;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class DPUPlayerEvent extends DPUEvent {

    public static class DPUPlayerRandomEvent extends DPUWorldEvent{
        public DPUPlayerRandomEvent(JsonElement o) {
            super(o);
        }
        float chance = 0;
        int min_ticks;
        int ticks_since_last = 0;
        @Override
        public DPUEvent Deserialize(JsonObject object) {
            min_ticks = class_3518.method_15282(object, "minimum_ticks", 10);
            if (object.has("chance")) {
                float c =object.get("chance").getAsFloat();
                if (c > 1) {
                    chance = c * 0.01f;
                } else if (c > 0){
                    chance = c;
                }
            }
            return super.Deserialize(object);
        }

        @Override
        public <T> boolean preProcessEvent(T data) {
            if (data instanceof class_1657 p) {
                class_1937 w = p.method_37908();
                if (min_ticks == 0) {
                    min_ticks = w.field_9229.method_43048(40);
                }
                if (ticks_since_last - 1 > min_ticks + w.field_9229.method_43048(20)) {
                    float f = w.field_9229.method_43057();
                    ticks_since_last = 0;
                    return f > chance && super.preProcessEvent(data);
                }
                ticks_since_last++;
                return false;
            }
            return false;
        }
    }
    UUID owner;
    String owner_name;
    float owner_health;
    int owner_hunger;
    int owner_armor;

    @Override
    public void putEventData(@Nullable class_1297 owner, class_1937 world, MinecraftServer server, class_2960 id) {
        if (owner != null) {
            DPUDataStorage.PushEvent(server, id.method_12832(), PutEntityData(owner));
        }
        super.putEventData(owner, world, server, id);
    }

    @Override
    public <T> boolean preProcessEvent(T data) {
        if (this.requiredNbt != null && requiredNbt.method_10546() != 0) {
            if (data instanceof class_1657 e) {
                class_2487 c = e.method_5647(new class_2487());
                return alib.checkNBTEquals(requiredNbt, c) && super.preProcessEvent(data);
            }
        }
        return super.preProcessEvent(data);
    }

    public class_2487 PutEntityData(class_1297 owner) {
        class_2487 res = new class_2487();
        this.owner = owner.method_5667();
        this.owner_name = owner.method_5477().getString();
        if (owner instanceof class_1309 e) {
            this.owner_health = e.method_6032();
            res.method_10548("owner_health", this.owner_health);
            if (e instanceof class_1657 p) {
                this.owner_hunger = p.method_7344().method_7586();
                res.method_10569("owner_hunger", this.owner_hunger);
            }
            this.owner_armor = e.method_6096();
            res.method_10569("owner_armor", this.owner_armor);
        }

        res.method_10582("owner_uuid", this.owner.toString());
        res.method_10582("owner_name", this.owner_name);
        res.method_10582("id", class_7923.field_41177.method_10221(owner.method_5864()).toString());
        return res;
    }
    public DPUPlayerEvent(JsonElement o) {
        super(o, DPUPlayerEvent::new);

    }
}
