package com.feintha.dpu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class MovementSpeedCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access){
        dispatcher.register(class_2170.method_9247("speed")
            .then(class_2170.method_9244("players", class_2186.method_9308())

                .then(class_2170.method_9247("flight").then(class_2170.method_9244("speed", FloatArgumentType.floatArg(0)).executes(context -> {
                    var es = class_2186.method_9312(context, "players");
                    if (es.size() == 0) {return 0;}
                    es.forEach(entity -> {
                        setFlightSpeed(entity, FloatArgumentType.getFloat(context, "speed"));
                    });
                    return 1;
                })))
                .then(class_2170.method_9247("walking").then(class_2170.method_9244("speed", FloatArgumentType.floatArg(0)).executes(context -> {
                    var es = class_2186.method_9312(context, "players");
                    if (es.size() == 0) {return 0;}
                    es.forEach(entity -> {
                        setWalkSpeed(entity, FloatArgumentType.getFloat(context, "speed"));
                    });
                    return 1;
                })))
            )
        );
    }
    static void setWalkSpeed(class_3222 entity, float speed) {
        entity.method_31549().method_7250(speed);
    }
    static void setFlightSpeed(class_3222 entity, float speed) {
        entity.method_31549().method_7248(speed);
    }
}
