package com.feintha.dpu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2203;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

import static com.feintha.dpu.commands.StringCommand.DATA_TYPE.*;

import I;

@SuppressWarnings("rawtypes")
public class StringCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access){
        LiteralArgumentBuilder<class_2168> _equals;
        LiteralArgumentBuilder<class_2168> _split;
        LiteralArgumentBuilder<class_2168> _concat;
        dispatcher.register(class_2170.method_9247("string")
                .then((_equals = class_2170.method_9247("equals"))
                        .then(addLocationTypes(_equals, (compound, context) -> {
                            var bl = compound.method_10558("left").contentEquals(compound.method_10558("right")) ? 1 : 0;
                            return bl;
                        }))
                )
                .then(_split = class_2170.method_9247("split"))
                .then(_concat = class_2170.method_9247("concat"))
        );
//            .then(CommandManager.literal("split")
//                .then(CommandManager.literal("storage").then(CommandManager.argument("location", IdentifierArgumentType.identifier()).then(CommandManager.argument("path", NbtPathArgumentType.nbtPath()).then(CommandManager.argument("by",StringArgumentType.string()).executes(StringCommand::string_split_storage)))))
//                .then(CommandManager.literal("entity").then(CommandManager.argument("entity", EntityArgumentType.entity()).then(CommandManager.argument("path", NbtPathArgumentType.nbtPath()).then(CommandManager.argument("by",StringArgumentType.string()).executes(StringCommand::string_split_entity)))))
//            )
//            .then(CommandManager.literal("concat")
//                    .then(CommandManager.literal("storage").then(CommandManager.argument("location", IdentifierArgumentType.identifier()).then(CommandManager.argument("path", NbtPathArgumentType.nbtPath()).then(CommandManager.argument("with",StringArgumentType.string()).executes(StringCommand::string_split_storage)))))
//                    .then(CommandManager.literal("entity").then(CommandManager.argument("entity", EntityArgumentType.entity()).then(CommandManager.argument("path", NbtPathArgumentType.nbtPath()).then(
//                            CommandManager.literal("const").then(CommandManager.argument("with", StringArgumentType.string()))).executes(StringCommand::string_split_entity)))))
//            )
//        );
    }
    static class DATA_TYPE<T extends ArgumentType> {
        public static DATA_TYPE<class_2232> STORAGE = new DATA_TYPE<>(class_2232.method_9441(), "storage");
        public static DATA_TYPE<StringArgumentType> CONST = new DATA_TYPE<>(StringArgumentType.string(), "const");
        public static DATA_TYPE<class_2186> ENTITY = new DATA_TYPE<>(class_2186.method_9309(), "entity");
        public static DATA_TYPE<class_2262> BLOCK = new DATA_TYPE<>(class_2262.method_9698(), "block");

        DATA_TYPE(T var, String name) {
            this.var = var;
            this.name = name;
        }
        public String name;
        public T var;
    }

    public static ArgumentBuilder<class_2168, ?> addLocationTypes(ArgumentBuilder<class_2168, ?> root, final BiFunction<class_2487, CommandContext<class_2168>, Integer> command) {
        ArgumentBuilder<class_2168, ?> root_e_L;
        ArgumentBuilder<class_2168, ?> root_b_L;
        ArgumentBuilder<class_2168, ?> root_c_L;
        ArgumentBuilder<class_2168, ?> root_s_L;
        var out =
                root
                        .then(class_2170.method_9247("block").then(class_2170.method_9244("location", class_2262.method_9698()).then((ArgumentBuilder<class_2168, ?>) (root_b_L = class_2170.method_9244("path", class_2203.method_9360())).then(addLocationTypesRight(root_b_L, BLOCK, command)))))
                        .then(class_2170.method_9247("entity").then(class_2170.method_9244("location", class_2186.method_9309()).then((ArgumentBuilder<class_2168, ?>) (root_e_L = class_2170.method_9244("path", class_2203.method_9360())).then(addLocationTypesRight(root_e_L, ENTITY, command)))))
                        .then(class_2170.method_9247("const").then((root_c_L = class_2170.method_9244("source", StringArgumentType.string()))).then(addLocationTypesRight(root_c_L, CONST, command)))
                        .then(class_2170.method_9247("storage").then(class_2170.method_9244("location", class_2232.method_9441()).then((ArgumentBuilder<class_2168, ?>) (root_s_L = class_2170.method_9244("path", class_2203.method_9360())).then(addLocationTypesRight(root_s_L, STORAGE, command)))))
                ;
        return out;
    }
    @SuppressWarnings("unchecked")
    public static <T> ArgumentBuilder<class_2168, ?> addLocationTypesRight(ArgumentBuilder<class_2168, ?> root, DATA_TYPE type, final BiFunction<class_2487, CommandContext<class_2168>, Integer> command) {

        ArgumentBuilder<class_2168, ?> root_e_L;
        ArgumentBuilder<class_2168, ?> root_b_L;
        ArgumentBuilder<class_2168, ?> root_c_L;
        ArgumentBuilder<class_2168, ?> root_s_L;
        var out =
                root
                        .then(class_2170.method_9247("block").then(class_2170.method_9244("location2", class_2262.method_9698()).then((ArgumentBuilder<class_2168, ?>) (root_b_L = class_2170.method_9244("path2", class_2203.method_9360())).executes(context -> string_util_loc(type, DATA_TYPE.BLOCK, context, command)))))
                        .then(class_2170.method_9247("entity").then(class_2170.method_9244("location2", class_2186.method_9309()).then((ArgumentBuilder<class_2168, ?>) (root_e_L = class_2170.method_9244("path2", class_2203.method_9360())).executes(context -> string_util_loc(type, DATA_TYPE.ENTITY, context, command)))))
                        .then(class_2170.method_9247("const").then((root_c_L = class_2170.method_9244("dest", StringArgumentType.string()))).executes(context -> string_util_loc(type, DATA_TYPE.CONST, context, command)))
                        .then(class_2170.method_9247("storage").then(class_2170.method_9244("location2", class_2232.method_9441()).then((ArgumentBuilder<class_2168, ?>) (root_s_L = class_2170.method_9244("path2", class_2203.method_9360())).executes(context -> string_util_loc(type, STORAGE, context, command)))))
                ;
        return out;
    }
    private static class_2520 getDataFromLocation(CommandContext<class_2168> context, BiFunction<CommandContext<class_2168>, class_2960, class_2487> consumer) throws CommandSyntaxException {
        class_2960 location = class_2232.method_9443(context, "location");
        class_2203.class_2209 path = class_2203.method_9358(context, "path");
        var loc_data = consumer.apply(context, location);
        var p = path.method_9366(loc_data);
        if (p.size() > 0) {
            String s = p.stream().findFirst().get().method_10714();
            if (loc_data == null) {
                context.getSource().method_9213(class_2561.method_43470("Location " + location + " was not found."));
                throw new RuntimeException("Location " + path.toString() + " was not found in " +location + ". Ensure this is correct!");
            }
        }
        assert p.size() > 0;
        return p.stream().findFirst().get();
    }
    private static class_2520 getDataFromEntity(CommandContext<class_2168> context, BiFunction<CommandContext<class_2168>, class_1297, class_2487> consumer) throws CommandSyntaxException {
        class_1297 location = class_2186.method_9313(context, "location");
        class_2203.class_2209 path = class_2203.method_9358(context, "path");
        var loc_data = consumer.apply(context, location);
        var p = path.method_9366(loc_data);
        if (p.size() > 0) {
            String s = p.stream().findFirst().get().method_10714();
            if (loc_data == null) {
                context.getSource().method_9213(class_2561.method_43470("Entity " + location + " was not found."));
                throw new RuntimeException("Data at " + path.toString() + " was not found in " +location + ". Ensure this is correct!");
            }
        }
        assert p.size() > 0;
        return p.stream().findFirst().get();
    }
    private static class_2520 getDataFromBlock(CommandContext<class_2168> context, BiFunction<CommandContext<class_2168>, class_2586, class_2487> consumer) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_48299(context, "location");
        class_2203.class_2209 path = class_2203.method_9358(context, "path");
        var location =context.getSource().method_9225().method_8321(pos);
        var loc_data = consumer.apply(context, location);
        var p = path.method_9366(loc_data);
        if (p.size() > 0) {
            String s = p.stream().findFirst().get().method_10714();
            if (loc_data == null) {
                context.getSource().method_9213(class_2561.method_43470("Location " + location + " was not found."));
                throw new RuntimeException("Block at "+pos.method_23854()+" did not have any data at " + path.toString() + " was not found in " +location + ". Ensure this is correct!");
            }
        }
        assert p.size() > 0;
        return p.stream().findFirst().get();
    }

    private static class_2520 getDataFromLocationR(CommandContext<class_2168> context, BiFunction<CommandContext<class_2168>, class_2960, class_2487> consumer) throws CommandSyntaxException {
        class_2960 location = class_2232.method_9443(context, "location2");
        class_2203.class_2209 path = class_2203.method_9358(context, "path2");
        var loc_data = consumer.apply(context, location);
        var p = path.method_9366(loc_data);
        if (p.size() > 0) {
            String s = p.stream().findFirst().get().method_10714();
            if (loc_data == null) {
                context.getSource().method_9213(class_2561.method_43470("Location " + location + " was not found."));
                throw new RuntimeException("Location " + path.toString() + " was not found in " +location + ". Ensure this is correct!");
            }
        }
        assert p.size() > 0;
        return p.stream().findFirst().get();
    }
    private static class_2520 getDataFromEntityR(CommandContext<class_2168> context, BiFunction<CommandContext<class_2168>, class_1297, class_2487> consumer) throws CommandSyntaxException {
        class_1297 location = class_2186.method_9313(context, "location2");
        class_2203.class_2209 path = class_2203.method_9358(context, "path2");
        var loc_data = consumer.apply(context, location);
        var p = path.method_9366(loc_data);
        if (p.size() > 0) {
            String s = p.stream().findFirst().get().method_10714();
            if (loc_data == null) {
                context.getSource().method_9213(class_2561.method_43470("Entity " + location + " was not found."));
                throw new RuntimeException("Data at " + path.toString() + " was not found in " +location + ". Ensure this is correct!");
            }
        }
        assert p.size() > 0;
        return p.stream().findFirst().get();
    }
    private static class_2520 getDataFromBlockR(CommandContext<class_2168> context, BiFunction<CommandContext<class_2168>, class_2586, class_2487> consumer) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_48299(context, "location2");
        class_2203.class_2209 path = class_2203.method_9358(context, "path2");
        var location =context.getSource().method_9225().method_8321(pos);
        var loc_data = consumer.apply(context, location);
        var p = path.method_9366(loc_data);
        if (p.size() > 0) {
            String s = p.stream().findFirst().get().method_10714();
            if (loc_data == null) {
                context.getSource().method_9213(class_2561.method_43470("Location " + location + " was not found."));
                throw new RuntimeException("Block at "+pos.method_23854()+" did not have any data at " + path.toString() + " was not found in " +location + ". Ensure this is correct!");
            }
        }
        assert p.size() > 0;
        return p.stream().findFirst().get();
    }
    private static int string_util_loc(DATA_TYPE origin, DATA_TYPE second, CommandContext<class_2168> context, BiFunction<class_2487, CommandContext<class_2168>, Integer> consumer) throws CommandSyntaxException {
        class_2487 c = new class_2487();
        handleCasesLeft(origin,context,c);
        handleCasesRight(second,context,c);
        return consumer.apply(c, context);
    }
    private static void handleCasesLeft(DATA_TYPE origin, CommandContext<class_2168> context, class_2487 c) throws CommandSyntaxException {
        if (DATA_TYPE.CONST.equals(origin)) {
            c.method_10582("left", StringArgumentType.getString(context, "source"));
        } else if (STORAGE.equals(origin)) {
            var e = getDataFromLocation(context, (context1, identifier) -> context1.getSource().method_9211().method_22827().method_22546(identifier));
            c.method_10582("left", e.method_10714());
        } else if (DATA_TYPE.ENTITY.equals(origin)) {
            var e = getDataFromEntity(context, (context1, entity) -> {
                class_2487 e_C = new class_2487();
                entity.method_5647(e_C);
                return e_C;
            });
            c.method_10582("left", e.method_10714());
        } else if (DATA_TYPE.BLOCK.equals(origin)) {
            var e = getDataFromBlock(context, (context1, block) -> {
                class_2487 e_C = new class_2487();
                block.method_11014(e_C);
                return e_C;
            });
            c.method_10582("left", e.method_10714());
        }
    }
    private static void handleCasesRight(DATA_TYPE origin, CommandContext<class_2168> context, class_2487 c) throws CommandSyntaxException {
        if (DATA_TYPE.CONST.equals(origin)) {
            c.method_10582("right", StringArgumentType.getString(context, "dest"));
        } else if (STORAGE.equals(origin)) {
            var e = getDataFromLocationR(context, (context1, identifier) -> context1.getSource().method_9211().method_22827().method_22546(identifier));
            c.method_10582("right", e.method_10714());
        } else if (DATA_TYPE.ENTITY.equals(origin)) {
            var e = getDataFromEntityR(context, (context1, entity) -> {
                class_2487 e_C = new class_2487();
                entity.method_5647(e_C);
                return e_C;
            });
            c.method_10582("right", e.method_10714());
        } else if (DATA_TYPE.BLOCK.equals(origin)) {
            var e = getDataFromBlockR(context, (context1, block) -> {
                class_2487 e_C = new class_2487();
                block.method_11014(e_C);
                return e_C;
            });
            c.method_10582("right", e.method_10714());
        }
    }

}
