package com.feintha.dpu.mixin.Client;

import com.feintha.dpu.iface.IBookContentsMixin;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.class_1799;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3518;
import net.minecraft.class_3872;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3872.class)
public abstract class BookScreenMixin {
    @Shadow private class_3872.class_3931 contents;
    @Shadow private int pageIndex;

    @Shadow protected abstract void goToNextPage();

    @Shadow @Final public static class_2960 BOOK_TEXTURE;
    @Unique
    class_1799 thisBook = class_1799.field_8037;
    @Inject(method="<init>(Lnet/minecraft/client/gui/screen/ingame/BookScreen$Contents;)V", at=@At("TAIL"))
    private void initMixin(class_3872.class_3931 pageProvider, CallbackInfo ci){
        try {
            IBookContentsMixin iM = (IBookContentsMixin) pageProvider;
            thisBook = iM.datapackUtils$getStack();
        } catch (Exception e) {
            System.err.println(e.toString());
        }
    }
    JsonObject cachedPageJson = null;

    @Inject(method="goToNextPage", at=@At("TAIL"))
    void goToNextPageMixin(CallbackInfo ci) {
        recacheJson();
    }
    @Inject(method="goToPreviousPage", at=@At("TAIL"))
    void goToPrevPageMixin(CallbackInfo ci) {
        recacheJson();
    }
    @Inject(method="setPage", at=@At("TAIL"))
    void goToPrevPageMixin(int index, CallbackInfoReturnable<Boolean> cir) {
        recacheJson();
    }

    private void recacheJson() {
        class_2499 nbtList = thisBook.method_7948().method_10554("pages", class_2520.field_33258).method_10612();
        cachedPageJson = class_3518.method_15285(nbtList.method_10608(pageIndex));
        mBookBgTexture = class_2960.method_12829(class_3518.method_15253(cachedPageJson, "background", BOOK_TEXTURE.toString()));
        String bgS = class_3518.method_15253(cachedPageJson, "foreground", null);
        if (bgS != null) {
            mBookFgTexture = class_2960.method_12829(bgS);
        } else {
            mBookFgTexture = null;
        }
        hasCustomPage = mBookBgTexture != BOOK_TEXTURE || bgS != null;
    }
    @Unique
    boolean hasCustomPage = false;
    @Unique
    public class_2960 mBookBgTexture = null;
    public class_2960 mBookFgTexture = null;
    @Inject(method="render", at=@At("HEAD"))
    void mixinRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci){}
    @WrapWithCondition(method="render", at=@At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"))
    boolean redirectBookTextureMixin(class_332 instance, class_2960 texture, int x, int y, int u, int v, int width, int height){
        if (cachedPageJson == null) {recacheJson();}
        if (hasCustomPage) {
            class_2960 id = new class_2960(mBookBgTexture.method_12836(), (mBookBgTexture.method_12832().endsWith(".png") ? mBookBgTexture.method_12832() : mBookBgTexture.method_12832() + ".png"));
            instance.method_25302(id, x, y, u, v, width, height);
            return false;
        }
        return true;
    }
    @Inject(method="render", at=@At("TAIL"))
    void renderEndMixin(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci){

        if (hasCustomPage) {

            if (mBookFgTexture != null) {
                class_2960 fgId = new class_2960(mBookFgTexture.method_12836(), (mBookFgTexture.method_12832().endsWith(".png") ? mBookFgTexture.method_12832() : mBookFgTexture.method_12832() + ".png"));
                int i = (((class_3872)(Object)this).field_22789 - 192) / 2;
                context.method_25302(fgId, i, 2, 0, 0, 192, 192);
            }
        }
    }
    @Mixin(class_3872.class_3932.class)
    public static class WritableBookContentMixin implements IBookContentsMixin{
        public class_1799 stack = class_1799.field_8037;
        @Inject(method="<init>", at=@At("TAIL"))
        private void getPagesMixin(class_1799 stack, CallbackInfo ci){
            this.stack = stack;
        }

        @Override
        public class_1799 datapackUtils$getStack() {
            return stack;
        }
    }
    @Mixin(class_3872.class_3933.class)
    public static class WrittenBookContentMixin implements IBookContentsMixin {
        public class_1799 stack = class_1799.field_8037;
        @Inject(method="<init>", at=@At("TAIL"))
        private void getPagesMixin(class_1799 stack, CallbackInfo ci){
            this.stack = stack;
        }

        @Override
        public class_1799 datapackUtils$getStack() {
            return stack;
        }
    }

}
