package com.feintha.dpu.mixin.Client;

import com.feintha.dpu.alib;
import com.google.common.collect.Maps;
import com.google.gson.*;
import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Environment(EnvType.CLIENT)
@Mixin(targets = "net.minecraft.client.render.model.json.ModelOverride$Deserializer")
public class ModelOverrideDeserializerMixin {
    // Unfortunately, I need to do this to allow different types. Sorry!
    @Inject(method="deserializeMinPropertyValues", at=@At("HEAD"), cancellable = true)
    private void onDeserializeMinPropertyValues(JsonObject object, CallbackInfoReturnable<List<class_799.class_5826>> cir) {
        Map<class_2960, Float> map = Maps.newLinkedHashMap();
        List<class_799.class_5826> conds = new ArrayList<>();

        JsonObject jsonObject = class_3518.method_15296(object, "predicate");
        for (Map.Entry<String, JsonElement> stringJsonElementEntry : jsonObject.entrySet()) {
//            if (stringJsonElementEntry.getValue().isJsonObject()) {
//                // assume NBT
//                ModelOverride.Condition cond = new ModelOverride.Condition(new Identifier(stringJsonElementEntry.getKey()), 1);
//                NbtCompound cond_d = alib.json2NBT(stringJsonElementEntry.getValue().getAsJsonObject());
//                alib.setMixinField(cond, "data", cond_d);
//                alib.setMixinField(cond, "isNBTOverride", true);
//                this.hasNBTOverride = true;
//                conds.add(cond);
//                continue;
//            }
            if (class_3518.method_34921(stringJsonElementEntry.getValue())) {
                boolean s = class_3518.method_15268(stringJsonElementEntry.getValue(), stringJsonElementEntry.getKey());
                float v = s ? 0.07991f : 0;
                conds.add(new class_799.class_5826(new class_2960(stringJsonElementEntry.getKey()), v));
                continue;
            }
            conds.add(new class_799.class_5826(new class_2960(stringJsonElementEntry.getKey()), class_3518.method_15269(stringJsonElementEntry.getValue(), stringJsonElementEntry.getKey())));
        }
        cir.setReturnValue (conds);
    }
    boolean hasNBTOverride = false;
    @Redirect(method = "deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/client/render/model/json/ModelOverride;", at = @At(value = "NEW", target = "(Lnet/minecraft/util/Identifier;Ljava/util/List;)Lnet/minecraft/client/render/model/json/ModelOverride;"))
    class_799 deserializeMixin(class_2960 modelId, List<class_799.class_5826> conditions, @Local class_2960 modelID, @Local List<class_799.class_5826> conds) {
        var ret = new class_799(modelID, conds);
        if (hasNBTOverride) {
            alib.setMixinField(ret, "isNBTOverride", true);
        }
        return ret;
    }
}
