package com.feintha.dpu.mixin;

import com.feintha.dpu.*;
import com.feintha.dpu.Events.DPUPlayerEvent;
import com.feintha.dpu.client.DatapackUtilsClient;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public class PlayerEntityMixin {
    int lastJumpTick = 0;
    @Inject(method="jump", at=@At("TAIL"))
    public void setJumping(CallbackInfo ci) {
        class_1657 _this = (class_1657)(Object)this;
        if (_this.method_37908().field_9236) {
            var evs = DPU.getAllClientEventsFor(DPUEventType.ON_JUMP);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutEntityData(_this);
                }
                ev.doActionClientAt(_this.method_19538(), false, _this);
            }
            lastJumpTick = DatapackUtilsClient.worldTick;
        } else {
            var evs = DPU.getAllServerEventsFor(DPUEventType.ON_JUMP);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutEntityData(_this);
                }
                ev.doActionServerAt((class_3218) _this.method_37908(), _this, _this.method_19538(), true, _this);
            }
            lastJumpTick = _this.method_37908().method_8503().method_3780();
        }
    }
    void exec(class_1657 _this, DPUEventType type) {
        if (_this.method_37908().field_9236) {
            var evs = DPU.getAllClientEventsFor(type);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutEntityData(_this);
                }
                ev.doActionClientAt(_this.method_19538(), false, _this);
            }
        } else {
            var evs = DPU.getAllServerEventsFor(type);
            for (DPUEvent ev : evs) {
                if (ev instanceof DPUPlayerEvent playerEvent) {
                    playerEvent.PutEntityData(_this);
                }
                ev.doActionServerAt((class_3218) _this.method_37908(), _this, _this.method_19538(), true, _this);
            }
        }
    }
    void exec(class_1657 _this, DPUEventType type, class_2960 id, boolean immediate) {
        if (_this.method_37908().field_9236) {
            DPU.InvokeClientEventFor(type, id);
        } else {
            DPU.InvokeServerEventFor(type, id, (class_3218) _this.method_37908(), _this, immediate, _this);
        }
    }
    void exec(class_1657 _this, DPUEventType type, class_2960 id, class_243 pos) {
        if (_this.method_37908().field_9236) {
            DPU.InvokeClientEventForAt(type, id, pos);
        } else {
            DPU.InvokeServerEventForAt(type, id, pos, (class_3218) _this.method_37908(), _this, _this);
        }
    }

    public void emitGameEvent(class_5712 event) {
        class_1657 _this = (class_1657) (Object) this;
        _this.method_37908().method_43275(_this, event, _this.method_19538());
    }
    boolean sneakLast = false;
    boolean shieldLast = false;
    @Inject(method="tick",at=@At("TAIL"))
    void tickInject(CallbackInfo ci) {
        class_1657 _this = (class_1657) (Object) this;
//        if (_this.isBlocking()) {
//            if (!shieldLast) {
//                exec(_this, DPUEventType.ON_SHIELD_RAISE);
//            } else {
//                exec(_this, DPUEventType.WHILE_SHIELD_RAISED);
//            }
//        } else if (shieldLast) {
//            exec(_this, DPUEventType.ON_SHIELD_LOWER);
//        }
        if (_this.method_5715()) {
            if (!sneakLast) {
                exec(_this, DPUEventType.ON_SNEAK);
            } else {
                exec(_this, DPUEventType.WHILE_SNEAK);
            }
        } else if (sneakLast) {
            exec(_this, DPUEventType.ON_SNEAK_END);
        }
        if (_this.field_6252 && _this.field_6279 == 0) {
            class_2960 id = class_7923.field_41178.method_10221(_this.method_6047().method_7909());
            if (_this.method_37908().field_9236) {
                DPU.InvokeClientEventFor(DPUEventType.ON_SWING_EVENT, id, _this);
            } else {
                DPU.InvokeServerEventFor(DPUEventType.ON_SWING_EVENT, id, (class_3218) _this.method_37908(), _this, false, _this);
            }
        }
        sneakLast = _this.method_5715();
    }
    @Inject(method="eatFood", at=@At("TAIL"))
    void eatFoodMixin(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        class_1657 _this = (class_1657) (Object) this;
        exec(_this, DPUEventType.ON_EAT, class_7923.field_41178.method_10221(stack.method_7909()), true);

    }
}
