package com.feintha.dpu.mixin;


import com.feintha.dpu.DPU;
import com.feintha.dpu.DPUEventType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.BooleanSupplier;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.class_638;

@Mixin(class_1937.class)
public class WorldMixin {
    @Mixin(class_3218.class)
    public static abstract class ServerWorldMixin {
        @Shadow @Final private class_5268 worldProperties;

        boolean rainingLast = false;
        boolean thunderingLast = false;
        @Inject(method="tick", at=@At("TAIL"))
        void onTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci){
            class_3218 w = (class_3218) (Object)this;
            DPU.InvokeServerEventFor(DPUEventType.RANDOM_WORLD_TICK, w.method_44013().method_29177(), w, null, true, w);
        }
        @Inject(method="tickWeather", at=@At("TAIL"))
        void onTickWeather(CallbackInfo ci){
            boolean rC = worldProperties.method_156();
            boolean tC = worldProperties.method_203();
            class_3218 w = (class_3218) (Object)this;
            if (rC && !rainingLast) {
                DPU.InvokeServerEventFor(DPUEventType.ON_WORLD_BEGIN_RAINING,  w.method_44013().method_29177(), w, null, true, w);
                rainingLast = rC;
                thunderingLast = tC;
                return;
            } else if (!rC && rainingLast) {
                DPU.InvokeServerEventFor(DPUEventType.ON_WORLD_END_RAINING,  w.method_44013().method_29177(), w, null, true, w);
                rainingLast = rC;
                thunderingLast = tC;
                return;
            }
            if (tC && !thunderingLast) {
                DPU.InvokeServerEventFor(DPUEventType.ON_WORLD_BEGIN_THUNDER,  w.method_44013().method_29177(), w, null, true, w);

                rainingLast = rC;
                thunderingLast = tC;
                return;
            } else if (!tC && thunderingLast) {
                DPU.InvokeServerEventFor(DPUEventType.ON_WORLD_END_THUNDER,  w.method_44013().method_29177(), w, null, true, w);

                rainingLast = rC;
                thunderingLast = tC;
                return;
            }
        }
    }
    @Mixin(class_638.class)
    public static class ClientWorldMixin {
        @Shadow @Final private class_638.class_5271 clientWorldProperties;
        boolean rainingLast = false;
        boolean thunderingLast = false;
        @Inject(method="tickTime", at=@At("TAIL"))
        void tickTimeMixin(CallbackInfo ci){
            boolean rC = clientWorldProperties.method_156();
            boolean tC = clientWorldProperties.method_203();
            class_1937 w = (class_1937)(Object)this;
            if (rC && !rainingLast) {
                DPU.InvokeClientEventFor(DPUEventType.ON_WORLD_BEGIN_RAINING, w.method_44013().method_29177(), w);
            } else if (!rC && rainingLast) {
                DPU.InvokeClientEventFor(DPUEventType.ON_WORLD_END_RAINING, w.method_44013().method_29177(), w);
            }
            if (tC && !thunderingLast) {
                DPU.InvokeClientEventFor(DPUEventType.ON_WORLD_BEGIN_THUNDER,  w.method_44013().method_29177(),w);
            } else if (!tC && thunderingLast) {
                DPU.InvokeClientEventFor(DPUEventType.ON_WORLD_END_THUNDER,  w.method_44013().method_29177(),w);
            }
            rainingLast = rC;
            thunderingLast = tC;

        }
        @Inject(method="tick", at=@At("TAIL"))
        void onTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci){
            class_1937 w = (class_1937)(Object)this;
            DPU.InvokeClientEventFor(DPUEventType.RANDOM_WORLD_TICK, w.method_44013().method_29177(), w);
        }
    }
}
