/*
 * Decompiled with CFR 0.152.
 */
package com.feintha.dpu;

import com.feintha.dpu.DatapackUtils;
import com.feintha.dpu.alib;
import com.feintha.dpu.client.DatapackUtilsClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class DPUEvent {
    public boolean cancelEvent = false;
    public class_2960 function = null;
    public boolean serverOnly = false;
    public int actionLastTick = 0;
    public int requiredTickDelay = 0;
    public static JsonArray DESERIALIZE_OFFSET_ZERO = new JsonArray();
    List<DPUEvent> nestedEvents = new ArrayList<DPUEvent>();
    public class_3414 sound;
    public class_2396 particle;
    public class_243 ParticleOffset = new class_243(0.0, 0.0, 0.0);
    public float SoundVolume = 1.0f;
    public float SoundPitch = 1.0f;
    public class_2487 requiredNbt;
    final Function<JsonElement, DPUEvent> constructor;

    public DPUEvent(JsonElement o, Function<JsonElement, DPUEvent> constructor) {
        this.constructor = constructor;
        if (o.isJsonObject()) {
            this.nestedEvents.add(this.Deserialize(o.getAsJsonObject()));
        } else if (o.isJsonArray()) {
            this.nestedEvents = this.DeserializeNested(o.getAsJsonArray());
        } else {
            System.err.println("Incorrect type of event object, expected array or object, got primitive.");
        }
    }

    public DPUEvent(String input, Function<JsonElement, DPUEvent> constructor) {
        this((JsonElement)new JsonParser().parse(input).getAsJsonObject(), constructor);
    }

    public void putEventData(@Nullable class_1297 owner, class_1937 world, MinecraftServer server, class_2960 id) {
    }

    protected final void handleClientParticles() {
        assert (class_310.method_1551().field_1687 != null);
        if (this.particle != null) {
            assert (class_310.method_1551().field_1724 != null);
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            class_243 rot = class_310.method_1551().field_1724.method_5663();
            class_243 pOff = this.ParticleOffset.method_18806(rot).method_1019(pos);
            class_310.method_1551().field_1687.method_8406((class_2394)this.particle, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0.0, 0.0, 0.0);
        }
    }

    protected final void handleClientParticlesAt(class_243 pos) {
        assert (class_310.method_1551().field_1687 != null);
        if (this.particle != null) {
            class_243 pOff = this.ParticleOffset.method_1019(pos);
            class_310.method_1551().field_1687.method_8406((class_2394)this.particle, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0.0, 0.0, 0.0);
        }
    }

    protected final void handleServerParticles(class_3218 world, class_1297 owner) {
        if (this.particle != null) {
            class_243 pos = owner.method_33571();
            class_243 rot = owner.method_5720();
            class_243 pOff = this.ParticleOffset.method_18806(rot).method_1019(pos);
            world.method_8466((class_2394)this.particle, true, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0.0, 0.0, 0.0);
        }
    }

    protected final void handleServerParticlesAt(class_3218 world, class_1297 owner, class_243 pos) {
        if (this.particle != null) {
            class_243 pOff = this.ParticleOffset.method_1019(pos);
            world.method_8466((class_2394)this.particle, true, pOff.field_1352, pOff.field_1351, pOff.field_1350, 0.0, 0.0, 0.0);
        }
    }

    protected final void handleFunction(class_3218 world, class_1297 owner) {
        if (this.function != null) {
            Optional func = world.method_8503().method_3740().method_12905(this.function);
            if (func.isPresent()) {
                world.method_8503().method_3740().method_12904((class_2158)func.get(), world.method_8503().method_3739().method_9232(owner));
            } else {
                System.out.println("Unable to execute function " + this.function + " when using event.");
            }
        }
    }

    protected final void handleFunctionAt(class_3218 world, class_1297 owner, class_243 pos) {
        if (this.function != null) {
            Optional func = world.method_8503().method_3740().method_12905(this.function);
            if (func.isPresent()) {
                world.method_8503().method_3740().method_12904((class_2158)func.get(), world.method_8503().method_3739().method_9208(pos).method_9232(owner));
            } else {
                System.out.println("Unable to execute function " + this.function + " when using event.");
            }
        }
    }

    protected final void handleClientSound() {
        assert (class_310.method_1551().field_1687 != null);
        if (this.sound != null) {
            assert (class_310.method_1551().field_1724 != null);
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            class_310.method_1551().field_1687.method_8486(pos.field_1352, pos.field_1351 - 0.25, pos.field_1350, this.sound, class_3419.field_15250, this.SoundVolume, this.SoundPitch, true);
        }
    }

    protected final void handleClientSoundAt(class_243 pos) {
        assert (class_310.method_1551().field_1687 != null);
        if (this.sound != null) {
            class_310.method_1551().field_1687.method_43128(null, pos.field_1352, pos.field_1351 - 0.25, pos.field_1350, this.sound, class_3419.field_15250, this.SoundVolume, this.SoundPitch);
        }
    }

    protected final void handleServerSound(class_3218 w, class_1297 owner) {
        if (this.sound != null) {
            class_243 pos = owner.method_33571();
            w.method_43128(null, pos.field_1352, pos.field_1351 - 0.25, pos.field_1350, this.sound, class_3419.field_15250, this.SoundVolume, this.SoundPitch);
        }
    }

    protected final void handleServerSoundAt(class_3218 w, class_1297 owner, class_243 pos) {
        if (this.sound != null) {
            w.method_43128(null, pos.field_1352, pos.field_1351 - 0.25, pos.field_1350, this.sound, class_3419.field_15250, this.SoundVolume, this.SoundPitch);
        }
    }

    public boolean doActionClient(boolean immediate) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSound();
                    e.handleClientParticles();
                });
                continue;
            }
            e.handleClientSound();
            e.handleClientParticles();
        }
        return c;
    }

    public boolean doActionClientAt(class_243 pos, boolean immediate) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSoundAt(pos);
                    e.handleClientParticlesAt(pos);
                });
                continue;
            }
            e.handleClientSoundAt(pos);
            e.handleClientParticlesAt(pos);
        }
        return c;
    }

    public <T> boolean doActionClient(boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            if (!e.preProcessEvent(data)) continue;
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSound();
                    e.handleClientParticles();
                });
                continue;
            }
            e.handleClientSound();
            e.handleClientParticles();
        }
        return c;
    }

    public <T> boolean doActionClientAt(class_243 pos, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            if (!e.preProcessEvent(data)) continue;
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtilsClient.ScheduleForNextWorldTick(clientWorld -> {
                    e.handleClientSoundAt(pos);
                    e.handleClientParticlesAt(pos);
                });
                continue;
            }
            e.handleClientSoundAt(pos);
            e.handleClientParticlesAt(pos);
        }
        return c;
    }

    public <T> boolean doActionServerAt(class_3218 world, class_243 pos, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            if (!e.preProcessEvent(data)) continue;
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick(s -> {
                    e.handleFunctionAt(world, null, pos);
                    e.handleServerSoundAt(world, null, pos);
                    e.handleServerParticlesAt(world, null, pos);
                });
                continue;
            }
            e.handleFunctionAt(world, null, pos);
            e.handleServerSoundAt(world, null, pos);
            e.handleServerParticlesAt(world, null, pos);
        }
        return c;
    }

    public boolean doActionServerAt(class_3218 world, class_243 pos, boolean immediate) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick(s -> {
                    e.handleFunctionAt(world, null, pos);
                    e.handleServerSoundAt(world, null, pos);
                    e.handleServerParticlesAt(world, null, pos);
                });
            }
            e.handleFunctionAt(world, null, pos);
            e.handleServerSoundAt(world, null, pos);
            e.handleServerParticlesAt(world, null, pos);
        }
        return c;
    }

    public <T> boolean doActionServer(class_3218 world, class_1297 owner, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            if (!e.preProcessEvent(data)) continue;
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick(s -> {
                    e.handleFunction(world, owner);
                    e.handleServerSound(world, owner);
                    e.handleServerParticles(world, owner);
                });
            }
            e.handleFunction(world, owner);
            e.handleServerSound(world, owner);
            e.handleServerParticles(world, owner);
        }
        return c;
    }

    public boolean doActionServer(class_3218 world, class_1297 owner, boolean immediate) {
        DatapackUtils.hasHadEvent = true;
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            c |= e.cancelEvent;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick(s -> {
                    e.handleFunction(world, owner);
                    e.handleServerSound(world, owner);
                    e.handleServerParticles(world, owner);
                });
                continue;
            }
            e.handleFunction(world, owner);
            e.handleServerSound(world, owner);
            e.handleServerParticles(world, owner);
        }
        return c;
    }

    public <T> boolean doActionServerAt(class_3218 world, class_1297 owner, class_243 pos, boolean immediate, T data) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            c |= e.cancelEvent;
            if (!e.preProcessEvent(data)) continue;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick(s -> {
                    e.handleFunctionAt(world, owner, pos);
                    e.handleServerSoundAt(world, owner, pos);
                    e.handleServerParticlesAt(world, owner, pos);
                });
                continue;
            }
            e.handleFunctionAt(world, owner, pos);
            e.handleServerSoundAt(world, owner, pos);
            e.handleServerParticlesAt(world, owner, pos);
        }
        return c;
    }

    public boolean doActionServerAt(class_3218 world, class_1297 owner, class_243 pos, boolean immediate) {
        boolean c = false;
        for (DPUEvent e : this.nestedEvents) {
            c |= e.cancelEvent;
            DatapackUtils.hasHadEvent = true;
            if (!immediate) {
                DatapackUtils.ScheduleForNextTick(s -> {
                    e.handleFunctionAt(world, owner, pos);
                    e.handleServerSoundAt(world, owner, pos);
                    e.handleServerParticlesAt(world, owner, pos);
                });
            }
            e.handleFunctionAt(world, owner, pos);
            e.handleServerSoundAt(world, owner, pos);
            e.handleServerParticlesAt(world, owner, pos);
        }
        return c;
    }

    public <T> boolean preProcessEvent(T data) {
        System.out.println("default event type used");
        return true;
    }

    public final List<DPUEvent> DeserializeNested(JsonArray array) {
        ArrayList<DPUEvent> events = new ArrayList<DPUEvent>();
        for (JsonElement obj : array) {
            DPUEvent elem = this.constructor.apply(obj);
            events.add(elem);
        }
        return events;
    }

    public DPUEvent Deserialize(JsonObject object) {
        JsonObject p_O;
        if (object.has("predicate") && (p_O = object.getAsJsonObject("predicate")).has("nbt")) {
            JsonObject p_N = p_O.getAsJsonObject("nbt");
            this.requiredNbt = alib.json2NBT(p_N);
        }
        if (object.has("cancels")) {
            this.cancelEvent = object.get("cancels").getAsBoolean();
        }
        if (object.has("function")) {
            this.function = new class_2960(object.get("function").getAsString());
        }
        this.serverOnly = class_3518.method_15258((JsonObject)object, (String)"onlyExecuteOnServer", (boolean)false);
        this.requiredTickDelay = class_3518.method_15282((JsonObject)object, (String)"delayBetweenEvents", (int)10);
        if (object.has("sound")) {
            JsonObject soundObjectPart = object.getAsJsonObject("sound");
            this.sound = class_3414.method_47908((class_2960)class_2960.method_12829((String)soundObjectPart.get("id").getAsString()));
            this.SoundPitch = class_3518.method_15277((JsonObject)soundObjectPart, (String)"pitch", (float)1.0f);
            this.SoundVolume = class_3518.method_15277((JsonObject)soundObjectPart, (String)"volume", (float)1.0f);
        }
        if (object.has("particle")) {
            JsonObject pObjectPart = object.getAsJsonObject("particle");
            this.particle = (class_2396)class_7923.field_41180.method_10223(new class_2960(pObjectPart.get("id").getAsString()));
            JsonArray pOffsetPart = class_3518.method_15292((JsonObject)pObjectPart, (String)"offset", (JsonArray)DESERIALIZE_OFFSET_ZERO);
            this.ParticleOffset = new class_243(pOffsetPart.get(0).getAsDouble(), pOffsetPart.get(1).getAsDouble(), pOffsetPart.get(2).getAsDouble());
        }
        return this;
    }

    static {
        DESERIALIZE_OFFSET_ZERO.add((Number)0);
        DESERIALIZE_OFFSET_ZERO.add((Number)0);
        DESERIALIZE_OFFSET_ZERO.add((Number)0);
    }

    public static enum DPUDayType {
        MIDNIGHT,
        DAY,
        NIGHT;

    }
}

