/*
 * Decompiled with CFR 0.152.
 */
package com.feintha.dpu.Events;

import com.feintha.dpu.DPUDataStorage;
import com.feintha.dpu.DPUEvent;
import com.feintha.dpu.Events.DPUWorldEvent;
import com.feintha.dpu.alib;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DPUPlayerEvent
extends DPUEvent {
    UUID owner;
    String owner_name;
    float owner_health;
    int owner_hunger;
    int owner_armor;

    @Override
    public void putEventData(@Nullable class_1297 owner, class_1937 world, MinecraftServer server, class_2960 id) {
        if (owner != null) {
            DPUDataStorage.PushEvent(server, id.method_12832(), (class_2520)this.PutEntityData(owner));
        }
        super.putEventData(owner, world, server, id);
    }

    @Override
    public <T> boolean preProcessEvent(T data) {
        if (this.requiredNbt != null && this.requiredNbt.method_10546() != 0 && data instanceof class_1657) {
            class_1657 e = (class_1657)data;
            class_2487 c = e.method_5647(new class_2487());
            return alib.checkNBTEquals(this.requiredNbt, c) && super.preProcessEvent(data);
        }
        return super.preProcessEvent(data);
    }

    public class_2487 PutEntityData(class_1297 owner) {
        class_2487 res = new class_2487();
        this.owner = owner.method_5667();
        this.owner_name = owner.method_5477().getString();
        if (owner instanceof class_1309) {
            class_1309 e = (class_1309)owner;
            this.owner_health = e.method_6032();
            res.method_10548("owner_health", this.owner_health);
            if (e instanceof class_1657) {
                class_1657 p = (class_1657)e;
                this.owner_hunger = p.method_7344().method_7586();
                res.method_10569("owner_hunger", this.owner_hunger);
            }
            this.owner_armor = e.method_6096();
            res.method_10569("owner_armor", this.owner_armor);
        }
        res.method_10582("owner_uuid", this.owner.toString());
        res.method_10582("owner_name", this.owner_name);
        res.method_10582("id", class_7923.field_41177.method_10221((Object)owner.method_5864()).toString());
        return res;
    }

    public DPUPlayerEvent(JsonElement o) {
        super(o, DPUPlayerEvent::new);
    }

    public static class DPUPlayerRandomEvent
    extends DPUWorldEvent {
        float chance = 0.0f;
        int min_ticks;
        int ticks_since_last = 0;

        public DPUPlayerRandomEvent(JsonElement o) {
            super(o);
        }

        @Override
        public DPUEvent Deserialize(JsonObject object) {
            this.min_ticks = class_3518.method_15282((JsonObject)object, (String)"minimum_ticks", (int)10);
            if (object.has("chance")) {
                float c = object.get("chance").getAsFloat();
                if (c > 1.0f) {
                    this.chance = c * 0.01f;
                } else if (c > 0.0f) {
                    this.chance = c;
                }
            }
            return super.Deserialize(object);
        }

        @Override
        public <T> boolean preProcessEvent(T data) {
            if (data instanceof class_1657) {
                class_1657 p = (class_1657)data;
                class_1937 w = p.method_37908();
                if (this.min_ticks == 0) {
                    this.min_ticks = w.field_9229.method_43048(40);
                }
                if (this.ticks_since_last - 1 > this.min_ticks + w.field_9229.method_43048(20)) {
                    float f = w.field_9229.method_43057();
                    this.ticks_since_last = 0;
                    return f > this.chance && super.preProcessEvent(data);
                }
                ++this.ticks_since_last;
                return false;
            }
            return false;
        }
    }
}

