/*
 * Decompiled with CFR 0.152.
 */
package com.feintha.dpu;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class alib {
    public static class_2487 packBlockStateIntoCompound(class_2680 s, class_2487 c) {
        for (class_2769 prop : s.method_28501()) {
            String n = prop.method_11899();
            class_2769.class_4933 value = prop.method_30041((class_2688)s);
            Comparable vL = value.comp_71();
            if (vL instanceof Number) {
                Number num = (Number)((Object)vL);
                if (num instanceof Float) {
                    Float f = (Float)num;
                    c.method_10548(n, f.floatValue());
                    continue;
                }
                if (num instanceof Double) {
                    Double d = (Double)num;
                    c.method_10549(n, d.doubleValue());
                    continue;
                }
                if (num instanceof Long) {
                    Long l = (Long)num;
                    c.method_10544(n, l.longValue());
                    continue;
                }
                if (num instanceof Integer) {
                    Integer i = (Integer)num;
                    c.method_10569(n, i.intValue());
                    continue;
                }
                if (num instanceof Byte) {
                    Byte b = (Byte)num;
                    c.method_10567(n, b.byteValue());
                    continue;
                }
                if (!(num instanceof Short)) continue;
                Short sH = (Short)num;
                c.method_10575(n, sH.shortValue());
                continue;
            }
            if (!(vL instanceof Boolean)) continue;
            Boolean bl = (Boolean)vL;
            c.method_10556(n, bl.booleanValue());
        }
        return c;
    }

    public static boolean checkNBTEquals(class_2487 left, class_2487 right) {
        if (left.method_10546() == right.method_10546() && left.method_10546() == 0) {
            return true;
        }
        boolean bl = true;
        for (String key : left.method_10541()) {
            if (!bl || !right.method_10545(key)) {
                return false;
            }
            class_2520 e_L = left.method_10580(key);
            class_2520 e_R = right.method_10580(key);
            byte elem_t = left.method_10540(key);
            if (right.method_10540(key) != elem_t) {
                return false;
            }
            class_2520 class_25202 = left.method_10580(key);
            if (class_25202 instanceof class_2499) {
                class_2499 lL = (class_2499)class_25202;
                class_25202 = right.method_10580(key);
                if (class_25202 instanceof class_2499) {
                    class_2499 rL = (class_2499)class_25202;
                    if (lL.size() != rL.size()) {
                        return false;
                    }
                    int i = 0;
                    for (class_2520 e : lL.subList(0, lL.size())) {
                        if (!e.method_10714().contentEquals(rL.method_10534(i).method_10714())) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            if (e_L instanceof class_2514) {
                class_2514 numL = (class_2514)e_L;
                if (e_R instanceof class_2514) {
                    class_2514 numR = (class_2514)e_R;
                    switch (elem_t) {
                        case 3: {
                            bl = numL.method_10701() == numR.method_10701();
                            break;
                        }
                        case 2: {
                            bl = numL.method_10696() == numR.method_10696();
                            break;
                        }
                        case 1: {
                            bl = numL.method_10698() == numR.method_10698();
                            break;
                        }
                        case 5: {
                            bl = numL.method_10700() == numR.method_10700();
                            break;
                        }
                        case 6: {
                            bl = numL.method_10697() == numR.method_10697();
                            break;
                        }
                        case 4: {
                            bl = numL.method_10699() == numR.method_10699();
                        }
                    }
                }
            }
            switch (elem_t) {
                case 10: {
                    bl = alib.checkNBTEquals(left.method_10562(key), right.method_10562(key));
                    break;
                }
                case 8: {
                    bl = e_L.method_10714().contentEquals(e_R.method_10714());
                }
            }
        }
        return bl;
    }

    public static class_2487 json2NBT(JsonObject jsonObject) {
        class_2487 nbtCompound = new class_2487();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonPrimitive()) {
                JsonPrimitive primitive = jsonElement.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    Number number = primitive.getAsNumber();
                    if (number instanceof Integer) {
                        Integer i = (Integer)number;
                        nbtCompound.method_10569(key, i.intValue());
                        continue;
                    }
                    number = primitive.getAsNumber();
                    if (number instanceof Float) {
                        Float i = (Float)number;
                        nbtCompound.method_10548(key, i.floatValue());
                        continue;
                    }
                    number = primitive.getAsNumber();
                    if (number instanceof Double) {
                        Double i = (Double)number;
                        nbtCompound.method_10549(key, i.doubleValue());
                        continue;
                    }
                    number = primitive.getAsNumber();
                    if (!(number instanceof Short)) continue;
                    Short i = (Short)number;
                    nbtCompound.method_10575(key, i.shortValue());
                    continue;
                }
                if (primitive.isBoolean()) {
                    nbtCompound.method_10556(key, primitive.getAsBoolean());
                    continue;
                }
                if (!primitive.isString()) continue;
                nbtCompound.method_10582(key, primitive.getAsString());
                continue;
            }
            if (!jsonElement.isJsonObject() && !jsonElement.isJsonArray()) continue;
            class_2487 nestedCompound = alib.json2NBT(jsonElement.getAsJsonObject());
            nbtCompound.method_10566(key, (class_2520)nestedCompound);
        }
        return nbtCompound;
    }

    public static <F, T> F getMixinField(T mixinType, String fieldName) {
        try {
            Field f = mixinType.getClass().getField(fieldName);
            return (F)f.get(mixinType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <F, T> F setMixinField(T mixinType, String fieldName, F value) {
        try {
            Field f = mixinType.getClass().getField(fieldName);
            f.set(mixinType, value);
            return (F)f.get(mixinType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <F, T> F setPrivateMixinField(T mixinType, String fieldName, F value) {
        try {
            Field f = mixinType.getClass().getField(fieldName);
            f.setAccessible(true);
            f.set(mixinType, value);
            return (F)f.get(mixinType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <F, T> F getPrivateMixinField(T mixinType, String fieldName) {
        try {
            Field f = mixinType.getClass().getDeclaredField(fieldName);
            return (F)f.get(mixinType);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Comparable> T parseInputString(String input, String format) {
        assert (format.startsWith("%"));
        String result = String.format(input, format);
        return (T)(switch (format.charAt(format.length() - 1)) {
            case 'd' -> Double.parseDouble(result);
            case 'f' -> Float.valueOf(Float.parseFloat(result));
            case 'i' -> Integer.parseInt(result);
            case 'b' -> Boolean.parseBoolean(result);
            case 'o' -> Integer.parseInt(result, 3);
            case 'h' -> result;
            default -> throw new IllegalStateException("Unexpected value: " + format.charAt(format.length() - 1));
        });
    }

    public static <T, R> R runMixinMethod(T mixinType, String methodName, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Method f = args.length > 0 ? mixinType.getClass().getMethod(methodName, argTypes) : mixinType.getClass().getMethod(methodName, new Class[0]);
            return (R)f.invoke(mixinType, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> R runConstructor(Class mixinType, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Constructor f = args.length > 0 ? mixinType.getConstructor(argTypes) : mixinType.getConstructor(new Class[0]);
            return (R)f.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> R runPrivateConstructor(Class mixinType, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
                System.out.println(argTypes[i]);
            }
            Constructor f = args.length > 0 ? mixinType.getDeclaredConstructor(argTypes) : mixinType.getDeclaredConstructor(new Class[0]);
            f.setAccessible(true);
            return (R)f.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> R runPrivateMixinMethod(T mixinType, String methodName, Object ... args) {
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Method f = args.length > 0 ? mixinType.getClass().getDeclaredMethod(methodName, argTypes) : mixinType.getClass().getDeclaredMethod(methodName, new Class[0]);
            f.setAccessible(true);
            return (R)f.invoke(mixinType, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static float getRandomFloat(class_5819 random, float minValue, float maxValue) {
        return minValue + random.method_43057() * (maxValue - minValue);
    }

    public static <T extends class_1297> List<T> getEntitiesOfTypeInRange(class_1937 world, class_2338 pos, double range, class_1299<T> type) {
        Predicate<class_1297> filter = entity -> entity.method_5864() == type && entity.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) <= range * range;
        return world.method_18023(type, class_238.method_30048((class_243)class_243.method_24954((class_2382)pos), (double)range, (double)range, (double)range), filter);
    }

    public static boolean isEntityNearBlock(class_1297 e, int radius, class_2248 ... blocks) {
        class_2338 entityPos = e.method_24515();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = entityPos.method_10069(x, y, z);
                    class_2248 block = e.method_37908().method_8320(pos).method_26204();
                    for (class_2248 b : blocks) {
                        System.out.println("check");
                        if (block != b) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static long getHash64(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        Adler32 adl32 = new Adler32();
        crc32.update(bytes);
        adl32.update(bytes);
        long crc = crc32.getValue();
        long adl = adl32.getValue();
        return (crc << 32 | adl) + crc << 8;
    }

    public static boolean stackCustomModelDataEquals(@NotNull class_1799 stack, int data) {
        if (!stack.method_7948().method_10545("CustomModelData")) {
            return false;
        }
        return stack.method_7948().method_10550("CustomModelData") == data;
    }

    public static long getHash64(String s) {
        return alib.getHash64(s.getBytes(StandardCharsets.UTF_8));
    }

    public static long bitenable(long var, long nbit) {
        return var |= 1L << (int)nbit;
    }

    public static long bitdisable(long var, long nbit) {
        return var &= 1L << (int)nbit;
    }

    public static long bitflip(long var, long nbit) {
        return var ^= 1L << (int)nbit;
    }

    public static boolean getbit(long var, long nbit) {
        return (var & 1L << (int)nbit) == 1L;
    }

    public static long setbit(long var, long nbit, boolean value) {
        if (value) {
            return alib.bitenable(var, nbit);
        }
        return alib.bitdisable(var, nbit);
    }

    public static boolean isBlockIn(class_2680 source, class_6862<class_2248> tag) {
        return source.method_26164(tag);
    }

    public static List<Pair<class_2960, class_2248>> GetAllBlocksInTag(class_6862<class_2248> tag) {
        ArrayList<Pair<class_2960, class_2248>> data = new ArrayList<Pair<class_2960, class_2248>>();
        Optional init_BLOCKS = class_7923.field_41175.method_40266(tag);
        init_BLOCKS.ifPresent(registryEntries -> registryEntries.forEach(entry -> {
            class_2960 id = ((class_5321)entry.method_40230().get()).method_29177();
            class_2248 block = (class_2248)entry.comp_349();
            data.add(Pair.of((Object)id, (Object)block));
        }));
        return data;
    }

    public static List<Pair<class_2960, class_2248>> GetAllBlocksInTagAnd(class_6862<class_2248> tag, Consumer<Pair<class_2960, class_2248>> onFound) {
        ArrayList<Pair<class_2960, class_2248>> data = new ArrayList<Pair<class_2960, class_2248>>();
        Optional init_BLOCKS = class_7923.field_41175.method_40266(tag);
        init_BLOCKS.ifPresent(registryEntries -> registryEntries.forEach(entry -> {
            class_2960 id = ((class_5321)entry.method_40230().get()).method_29177();
            class_2248 block = (class_2248)entry.comp_349();
            data.add(Pair.of((Object)id, (Object)block));
            onFound.accept(Pair.of((Object)id, (Object)block));
        }));
        return data;
    }

    public static class_2338 getBlockPosFromArray(long[] a) {
        if (a.length < 3) {
            return class_2338.field_10980;
        }
        return new class_2338((int)a[0], (int)a[1], (int)a[2]);
    }

    public static long[] getBlockPosAsArray(class_2338 d) {
        if (d == null) {
            return new long[]{0L, 0L, 0L};
        }
        return new long[]{d.method_10263(), d.method_10264(), d.method_10260()};
    }

    public static double[] getVec3dAsArray(class_243 d) {
        if (d == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return new double[]{d.method_10216(), d.method_10214(), d.method_10215()};
    }

    public static Class<?> getFunctionTemplateClass(Object object, int index) {
        Type genericInterface = object.getClass().getGenericInterfaces()[0];
        if (genericInterface instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (index >= 0 && index < typeArguments.length) {
                return (Class)typeArguments[index];
            }
        }
        throw new IllegalArgumentException("Index out of bounds or template not found.");
    }

    public static Pair<Integer, Integer> XYPosFromOffset(int w, int offset) {
        assert (w != 0);
        int x = offset % w;
        assert (offset != 0);
        int y = offset / w;
        return Pair.of((Object)x, (Object)y);
    }

    public static double lerp(double a, double b, float f) {
        return a + (double)f * (b - a);
    }

    public static int mixRGB(int a, int b, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int aA = a >> 24 & 0xFF;
        int aR = (a & 0xFF0000) >> 16;
        int aG = (a & 0xFF00) >> 8;
        int aB = a & 0xFF;
        int bA = b >> 24 & 0xFF;
        int bR = (b & 0xFF0000) >> 16;
        int bG = (b & 0xFF00) >> 8;
        int bB = b & 0xFF;
        int A = (int)((float)aA * iRatio + (float)bA * ratio);
        int R = (int)((float)aR * iRatio + (float)bR * ratio);
        int G = (int)((float)aG * iRatio + (float)bG * ratio);
        int B = (int)((float)aB * iRatio + (float)bB * ratio);
        return A << 24 | R << 16 | G << 8 | B;
    }
}

