/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.items;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.structurecompass.component.StructureInfo;
import com.mrbysco.structurecompass.config.StructureConfig;
import com.mrbysco.structurecompass.network.message.OpenCompassPayload;
import com.mrbysco.structurecompass.registry.StructureComponents;
import com.mrbysco.structurecompass.util.AsyncLocator;
import com.mrbysco.structurecompass.util.StructureUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;

public class StructureCompassItem
extends Item {
    public StructureCompassItem(Item.Properties builder) {
        super(builder);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (playerIn.isShiftKeyDown()) {
            if (!worldIn.isClientSide) {
                List<ResourceLocation> allStructures = StructureUtil.getAvailableStructureList(worldIn);
                ((ServerPlayer)playerIn).connection.send((CustomPacketPayload)new OpenCompassPayload(hand, stack, allStructures));
            }
        } else {
            this.locateStructure(stack, playerIn);
        }
        return super.use(worldIn, playerIn, hand);
    }

    private void locateStructure(ItemStack stack, Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (stack.has(StructureComponents.STRUCTURE)) {
                ResourceLocation structureLocation = (ResourceLocation)stack.get(StructureComponents.STRUCTURE);
                if (structureLocation != null && !StructureUtil.isBlacklisted(structureLocation)) {
                    ResourceKey structureKey;
                    Registry registry = level2.registryAccess().registryOrThrow(Registries.STRUCTURE);
                    HolderSet featureHolderSet = registry.getHolder(structureKey = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)structureLocation)).map(holders -> HolderSet.direct((Holder[])new Holder[]{holders})).orElse(null);
                    if (featureHolderSet != null) {
                        Optional optionalHolder = registry.getHolder(structureKey);
                        if (optionalHolder.isPresent() && ((Holder.Reference)optionalHolder.get()).is(Tags.Structures.HIDDEN_FROM_LOCATOR_SELECTION)) {
                            stack.remove(StructureComponents.STRUCTURE);
                            player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.locate.structure_prohibited").withStyle(ChatFormatting.RED));
                            return;
                        }
                        player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.structure.locating", (Object[])new Object[]{structureLocation.toString()}).withStyle(ChatFormatting.YELLOW));
                        boolean findUnexplored = false;
                        if (((Boolean)StructureConfig.COMMON.locateUnexplored.get()).booleanValue()) {
                            findUnexplored = (Boolean)StructureConfig.COMMON.locateUnexplored.get();
                        }
                        if (((Boolean)StructureConfig.COMMON.locateAsync.get()).booleanValue()) {
                            AsyncLocator.LocateTask<Pair<BlockPos, Holder<Structure>>> async = AsyncLocator.locate(level2, (HolderSet<Structure>)featureHolderSet, player.blockPosition(), 100, findUnexplored);
                            async.thenOnServerThread(pair -> this.bindPosition(stack, structureLocation, player, (Level)level2, (Pair<BlockPos, Holder<Structure>>)pair));
                        } else {
                            Pair<BlockPos, Holder<Structure>> pair2 = StructureUtil.findNearestMapStructure(level2, (HolderSet<Structure>)featureHolderSet, player.blockPosition(), 100, findUnexplored);
                            this.bindPosition(stack, structureLocation, player, (Level)level2, pair2);
                        }
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.locate.fail").withStyle(ChatFormatting.RED));
                }
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.structure.unset.tooltip").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    private void bindPosition(ItemStack stack, ResourceLocation boundStructure, Player player, Level level, Pair<BlockPos, Holder<Structure>> pair) {
        BlockPos structurePos;
        BlockPos blockPos = structurePos = pair != null ? (BlockPos)pair.getFirst() : null;
        if (structurePos == null) {
            stack.remove(StructureComponents.STRUCTURE_INFO);
            int range = (Integer)StructureConfig.COMMON.compassRange.get();
            player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.structure.failed", (Object[])new Object[]{boundStructure.toString(), range}).withStyle(ChatFormatting.RED));
        } else {
            StructureInfo info = new StructureInfo(structurePos, (ResourceKey<Level>)level.dimension());
            stack.set(StructureComponents.STRUCTURE_INFO, (Object)info);
            int distance = player.blockPosition().distManhattan((Vec3i)structurePos);
            player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.structure.found", (Object[])new Object[]{boundStructure.toString(), distance}).withStyle(ChatFormatting.GREEN));
        }
        player.getCooldowns().addCooldown((Item)this, 100);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.has(StructureComponents.STRUCTURE)) {
            String structureName = ((ResourceLocation)stack.get(StructureComponents.STRUCTURE)).toString();
            if (stack.has(StructureComponents.STRUCTURE_INFO)) {
                StructureInfo info = (StructureInfo)stack.get(StructureComponents.STRUCTURE_INFO);
                if (context != null && Minecraft.getInstance().player != null && Minecraft.getInstance().player.level().dimension().location().equals((Object)info.dimension().location())) {
                    tooltip.add((Component)Component.translatable((String)"structurecompass.structure.found.tooltip", (Object[])new Object[]{structureName}).withStyle(ChatFormatting.GREEN));
                } else {
                    tooltip.add((Component)Component.translatable((String)"structurecompass.structure.wrong_dimension.tooltip", (Object[])new Object[]{structureName}).withStyle(ChatFormatting.RED));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"structurecompass.structure.failed.tooltip", (Object[])new Object[]{structureName}).withStyle(ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"structurecompass.structure.unset.tooltip").withStyle(ChatFormatting.GOLD));
        }
    }
}

