/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.util;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.structurecompass.StructureCompass;
import com.mrbysco.structurecompass.config.StructureConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.Tags;

public class StructureUtil {
    public static List<ResourceLocation> getAvailableStructureList(Level level) {
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        registry.holders().forEach(holder -> {
            if (holder.is(Tags.Structures.HIDDEN_FROM_LOCATOR_SELECTION)) {
                return;
            }
            ResourceLocation location = holder.key().location();
            if (!StructureUtil.isBlacklisted(location) && !structureList.contains(location)) {
                structureList.add(location);
            }
        });
        return structureList;
    }

    public static boolean isBlacklisted(ResourceLocation structureLocation) {
        if (structureLocation == null) {
            StructureCompass.LOGGER.error("Checking blacklist but fed location is null!");
            return false;
        }
        if (!((List)StructureConfig.COMMON.structureBlacklist.get()).isEmpty()) {
            if (((List)StructureConfig.COMMON.structureBlacklist.get()).contains(structureLocation.toString())) {
                return true;
            }
            List<String> wildcardList = ((List)StructureConfig.COMMON.structureBlacklist.get()).stream().filter(value -> value.contains(":") && value.contains("*")).toList();
            for (String wildcard : wildcardList) {
                String[] blacklistSplit = wildcard.split(":");
                if ((!blacklistSplit[0].equals("*") || !structureLocation.getPath().equals(blacklistSplit[1])) && (!blacklistSplit[1].equals("*") || !structureLocation.getNamespace().equals(blacklistSplit[0]))) continue;
                return true;
            }
        }
        return false;
    }

    public static Pair<BlockPos, Holder<Structure>> findNearestMapStructure(ServerLevel serverLevel, HolderSet<Structure> structureHolderSet, BlockPos pos, int range, boolean findUnexplored) {
        ChunkGenerator generator = serverLevel.getChunkSource().getGenerator();
        Pair nearest = generator.findNearestMapStructure(serverLevel, structureHolderSet, pos, range, findUnexplored);
        if (nearest == null) {
            return null;
        }
        return ((BlockPos)nearest.getFirst()).distManhattan((Vec3i)pos) <= (Integer)StructureConfig.COMMON.compassRange.get() ? nearest : null;
    }
}

