/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.property;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.structurecompass.component.StructureInfo;
import com.mrbysco.structurecompass.registry.StructureComponents;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StructureCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<StructureCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(wobble -> wobble.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)Boolean.FALSE).forGetter(rec$ -> ((StructureCompassAngleState)((Object)((Object)((Object)rec$)))).wobble())).apply((Applicative)wobble, StructureCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);

    public StructureCompassAngleState(boolean wobble) {
        super(wobble);
    }

    protected float calculate(ItemStack stack, ClientLevel level, int seed, @Nullable ItemOwner owner) {
        StructureInfo compassData = (StructureInfo)stack.get(StructureComponents.STRUCTURE_INFO.get());
        GlobalPos globalpos = compassData != null ? compassData.globalPos() : null;
        long i = level.getGameTime();
        boolean valid = StructureCompassAngleState.isValidCompassTargetPos(owner, globalpos);
        return !valid ? 0.0f : this.getRotationTowardsCompassTarget(owner, i, globalpos.pos());
    }

    private float getRotationTowardsCompassTarget(ItemOwner itemOwner, long gameTime, BlockPos targetOis) {
        Player player;
        float f = (float)StructureCompassAngleState.getAngleFromEntityToPos(itemOwner, targetOis);
        float f1 = StructureCompassAngleState.getWrappedVisualRotationY(itemOwner);
        LivingEntity livingEntity = itemOwner.asLivingEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (f1 - 0.25f));
            }
            float f3 = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)f3, (float)1.0f);
        }
        float f2 = 0.5f - (f1 - 0.25f - f);
        return Mth.positiveModulo((float)f2, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(ItemOwner itemOwner, @Nullable GlobalPos pos) {
        return pos != null && pos.dimension() == itemOwner.level().dimension() && !(pos.pos().distToCenterSqr((Position)itemOwner.position()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(ItemOwner itemOwner, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3.z() - itemOwner.position().z(), vec3.x() - itemOwner.position().x()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(ItemOwner itemOwner) {
        return Mth.positiveModulo((float)(itemOwner.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }
}

