/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.screen.widget;

import com.mrbysco.structurecompass.client.screen.CompassScreen;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public class StructureListWidget
extends ObjectSelectionList<ListEntry> {
    private final CompassScreen parent;
    private final int listWidth;

    public StructureListWidget(CompassScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraft();
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int scrollBarX() {
        return this.getX() + this.listWidth - 6;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        this.clearEntries();
        this.parent.buildStructureList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((ResourceLocation)location, this.parent));
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final ResourceLocation structureLocation;
        private final CompassScreen parent;

        ListEntry(ResourceLocation location, CompassScreen parent) {
            this.structureLocation = location;
            this.parent = parent;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            String structureName = this.structureLocation.toString();
            MutableComponent name = Component.literal((String)structureName);
            Font font = this.parent.getFontRenderer();
            int top = this.getContentY();
            guiGraphics.drawString(font, Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, StructureListWidget.this.listWidth)})), this.parent.width / 2 - font.width(structureName) / 2 + 3, top + 6, ARGB.opaque((int)0xFFFFFF), false);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            this.parent.setSelected(this);
            StructureListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public void setFocused(boolean focused) {
            if (focused) {
                this.parent.setSelected(this);
                StructureListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            }
        }

        public boolean isFocused() {
            return StructureListWidget.this.getSelected() == this;
        }

        public ResourceLocation getStructureLocation() {
            return this.structureLocation;
        }

        @NotNull
        public Component getNarration() {
            return Component.literal((String)this.getStructureLocation().getPath());
        }
    }
}

