/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.datagen;

import com.mrbysco.structurecompass.client.property.StructureCompassAngle;
import com.mrbysco.structurecompass.registry.StructureItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ItemTagsProvider;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class CompassDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new CompassRecipeProvider.Runner(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CompassBlockTagProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CompassItemTagProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CompassStructureProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new CompassModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new CompassLangProvider(packOutput));
    }

    public static class CompassRecipeProvider
    extends RecipeProvider {
        public CompassRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            super(provider, recipeOutput);
        }

        protected void buildRecipes() {
            this.shaped(RecipeCategory.TOOLS, (ItemLike)StructureItems.STRUCTURE_COMPASS.get()).pattern("WTS").pattern("O#D").pattern("MCP").define(Character.valueOf('#'), (ItemLike)Items.COMPASS).define(Character.valueOf('W'), (ItemLike)Blocks.SNOW_BLOCK).define(Character.valueOf('T'), (ItemLike)Blocks.TERRACOTTA).define(Character.valueOf('S'), (ItemLike)Blocks.SANDSTONE).define(Character.valueOf('O'), (ItemLike)Blocks.OAK_LOG).define(Character.valueOf('D'), (ItemLike)Blocks.DARK_OAK_LOG).define(Character.valueOf('M'), (ItemLike)Blocks.MOSSY_COBBLESTONE).define(Character.valueOf('C'), (ItemLike)Blocks.COBBLESTONE).define(Character.valueOf('P'), (ItemLike)Blocks.CARVED_PUMPKIN).unlockedBy("has_compass", this.has((ItemLike)Items.COMPASS)).save(this.output);
        }

        public static class Runner
        extends RecipeProvider.Runner {
            public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> completableFuture) {
                super(output, completableFuture);
            }

            protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
                return new CompassRecipeProvider(provider, recipeOutput);
            }

            public String getName() {
                return "Structure Compass Recipes";
            }
        }
    }

    public static class CompassBlockTagProvider
    extends BlockTagsProvider {
        public CompassBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "structurecompass");
        }

        protected void addTags(HolderLookup.Provider provider) {
        }
    }

    public static class CompassItemTagProvider
    extends ItemTagsProvider {
        public CompassItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "structurecompass");
        }

        public void addTags(HolderLookup.Provider lookupProvider) {
            this.tag(ItemTags.COMPASSES).add((Object)((Item)StructureItems.STRUCTURE_COMPASS.get()));
        }
    }

    public static class CompassStructureProvider
    extends StructureTagsProvider {
        public CompassStructureProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "structurecompass");
        }

        public void addTags(HolderLookup.Provider lookupProvider) {
            this.tag(Tags.Structures.HIDDEN_FROM_LOCATOR_SELECTION);
        }
    }

    public static class CompassModelProvider
    extends ModelProvider {
        public CompassModelProvider(PackOutput output) {
            super(output, "structurecompass");
        }

        protected void registerModels(@NotNull BlockModelGenerators blockModels, @NotNull ItemModelGenerators itemModels) {
            this.generateStructureCompass(itemModels, (Item)StructureItems.STRUCTURE_COMPASS.get());
        }

        public void generateStructureCompass(ItemModelGenerators itemModels, Item item) {
            List list = itemModels.createCompassModels(item);
            itemModels.itemModelOutput.accept(item, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new StructureCompassAngle(false), (float)32.0f, (List)list));
        }
    }

    public static class CompassLangProvider
    extends LanguageProvider {
        public CompassLangProvider(PackOutput packOutput) {
            super(packOutput, "structurecompass", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.structurecompass", "Structure Compass");
            this.addItem((Supplier)StructureItems.STRUCTURE_COMPASS, "Structure Compass");
            this.add("structurecompass.screen.selection.title", "Structure Selection");
            this.add("structurecompass.screen.selection.select", "Select");
            this.add("structurecompass.screen.selection.selected", "Structure selected, right-click the compass to locate it");
            this.add("structurecompass.screen.search", "Search");
            this.add("structurecompass.screen.search.a_to_z", "A-Z");
            this.add("structurecompass.screen.search.z_to_a", "Z-A");
            this.add("structurecompass.locate.invalid", "Bound structure invalid. Please re-bind");
            this.add("structurecompass.locate.fail", "Bound structure could not be located nearby");
            this.add("structurecompass.locate.distance", "Bound structure is %s blocks away");
            this.add("structurecompass.locate.toggled", "Structure Compass hud toggled %s");
            this.add("structurecompass.locate.structure_prohibited", "You are not allowed to locate this structure");
            this.add("structurecompass.structure.locating", "Attempting to locate %s, please wait...");
            this.add("structurecompass.structure.found", "%s has been located %s blocks away, compass is pointing towards the structure");
            this.add("structurecompass.structure.found.tooltip", "%s has been located, compass is pointing towards the structure");
            this.add("structurecompass.structure.failed", "%s can not be located within a %s block radius. Please explore further and try again later");
            this.add("structurecompass.structure.failed.tooltip", "%s can not be located, perhaps try again later");
            this.add("structurecompass.structure.wrong_dimension.tooltip", "You are not in the dimension in which %s was found");
            this.add("structurecompass.structure.unset.tooltip", "No structure has been set, shift right-click to select a structure");
            this.add("category.structurecompass.main", "Structure Compass");
            this.add("key.structurecompass.hide", "Hide Structure Compass HUD");
            this.add("structurecompass.networking.set_structure.failed", "Failed to set structure: %s");
            this.addConfig("title", "Structure Compass Config", null);
            this.addConfig("general", "General", "General Settings");
            this.addConfig("compassRange", "Compass Range", "Sets the range in blocks in which the structure compasses can locate structures");
            this.addConfig("locateUnexplored", "Locate Unexplored", "Defines if the structure compass should only locate unexplored structures. A structure is tagged as explored when the compass is used to find it.");
            this.addConfig("locateAsync", "Locate Asynchronously", "Defines if the structure compass should locate structures asynchronously");
            this.addConfig("structureBlacklist", "Structure Blacklist", "Defines which structures can't be searched with the Structure Compass\n(Supports wildcard *, Example: 'minecraft:*' will blacklist anything in the minecraft domain)");
        }

        private void addConfig(String path, String name, @Nullable String description) {
            this.add("structurecompass.configuration." + path, name);
            if (description != null && !description.isEmpty()) {
                this.add("structurecompass.configuration." + path + ".tooltip", description);
            }
        }
    }
}

