/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mrbysco.structurecompass.client.ClientHandler;
import com.mrbysco.structurecompass.component.StructureInfo;
import com.mrbysco.structurecompass.registry.StructureComponents;
import com.mrbysco.structurecompass.registry.StructureItems;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class KeyHandler {
    public static boolean hidden = false;

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (minecraft.screen != null && event.getAction() != 1) {
            return;
        }
        if (InputConstants.isKeyDown((long)minecraft.getWindow().getWindow(), (int)292)) {
            return;
        }
        if (ClientHandler.KEY_TOGGLE.consumeClick() && player != null) {
            hidden = !hidden;
            player.displayClientMessage((Component)Component.translatable((String)"structurecompass.locate.toggled", (Object[])new Object[]{hidden ? "off" : "on"}), false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.tickCount % 10 == 0 && player.isHolding((Item)StructureItems.STRUCTURE_COMPASS.get()) && !hidden) {
            ItemStack stack = player.getMainHandItem();
            if (!stack.is((Item)StructureItems.STRUCTURE_COMPASS.get()) && !(stack = player.getOffhandItem()).is((Item)StructureItems.STRUCTURE_COMPASS.get())) {
                return;
            }
            if (stack.has(StructureComponents.STRUCTURE_INFO)) {
                StructureInfo info = (StructureInfo)stack.get(StructureComponents.STRUCTURE_INFO);
                GlobalPos globalPos = info.globalPos();
                ResourceLocation structureDimension = globalPos.dimension().location();
                if (player.level().dimension().location().equals((Object)structureDimension)) {
                    int distance = player.blockPosition().distManhattan((Vec3i)globalPos.pos());
                    player.displayClientMessage((Component)Component.translatable((String)"structurecompass.locate.distance", (Object[])new Object[]{distance}).withStyle(ChatFormatting.YELLOW), true);
                }
            }
        }
    }
}

