/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.property;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.structurecompass.component.StructureInfo;
import com.mrbysco.structurecompass.registry.StructureComponents;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class StructureCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<StructureCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(wobble -> wobble.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)Boolean.FALSE).forGetter(rec$ -> ((StructureCompassAngleState)((Object)((Object)((Object)rec$)))).wobble())).apply((Applicative)wobble, StructureCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);

    public StructureCompassAngleState(boolean wobble) {
        super(wobble);
    }

    protected float calculate(ItemStack stack, ClientLevel level, int seed, Entity targetPos) {
        StructureInfo compassData = (StructureInfo)stack.get(StructureComponents.STRUCTURE_INFO.get());
        GlobalPos globalpos = compassData != null ? compassData.globalPos() : null;
        long i = level.getGameTime();
        boolean valid = StructureCompassAngleState.isValidCompassTargetPos(targetPos, globalpos);
        return !valid ? 0.0f : this.getRotationTowardsCompassTarget(targetPos, i, globalpos.pos());
    }

    private float getRotationTowardsCompassTarget(Entity entity, long gameTime, BlockPos targetOis) {
        Player player;
        float f = (float)StructureCompassAngleState.getAngleFromEntityToPos(entity, targetOis);
        float f1 = StructureCompassAngleState.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (f1 - 0.25f));
            }
            float f3 = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)f3, (float)1.0f);
        }
        float f2 = 0.5f - (f1 - 0.25f - f);
        return Mth.positiveModulo((float)f2, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(Entity entity, @Nullable GlobalPos pos) {
        return pos != null && pos.dimension() == entity.level().dimension() && !(pos.pos().distToCenterSqr((Position)entity.position()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((float)(entity.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }
}

