/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass;

import com.mojang.logging.LogUtils;
import com.mrbysco.structurecompass.client.ClientHandler;
import com.mrbysco.structurecompass.client.KeyHandler;
import com.mrbysco.structurecompass.config.StructureConfig;
import com.mrbysco.structurecompass.network.PacketHandler;
import com.mrbysco.structurecompass.registry.StructureComponents;
import com.mrbysco.structurecompass.registry.StructureItems;
import com.mrbysco.structurecompass.util.AsyncLocator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.slf4j.Logger;

@Mod(value="structurecompass")
public class StructureCompass {
    public static final Logger LOGGER = LogUtils.getLogger();

    public StructureCompass(IEventBus eventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)StructureConfig.commonSpec);
        eventBus.register(StructureConfig.class);
        eventBus.addListener(PacketHandler::setupPackets);
        StructureComponents.DATA_COMPONENT_TYPES.register(eventBus);
        StructureItems.ITEMS.register(eventBus);
        StructureItems.CREATIVE_MODE_TABS.register(eventBus);
        NeoForge.EVENT_BUS.addListener(this::serverAboutToStart);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::onClientSetup);
            eventBus.addListener(ClientHandler::registerKeyMappings);
            NeoForge.EVENT_BUS.register((Object)new KeyHandler());
        }
    }

    private void serverAboutToStart(ServerAboutToStartEvent event) {
        AsyncLocator.handleServerAboutToStartEvent();
    }

    private void onServerStopping(ServerStoppingEvent event) {
        AsyncLocator.handleServerStoppingEvent();
    }
}

