/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mrbysco.structurecompass.client.screen.CompassScreen;
import com.mrbysco.structurecompass.component.StructureInfo;
import com.mrbysco.structurecompass.registry.StructureComponents;
import com.mrbysco.structurecompass.registry.StructureItems;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientHandler {
    public static final KeyMapping KEY_TOGGLE = new KeyMapping("key.structurecompass.hide", InputConstants.Type.KEYSYM, -1, "category.structurecompass.main");

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)StructureItems.STRUCTURE_COMPASS.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"angle"), (ItemPropertyFunction)new ItemPropertyFunction(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingBaseIn, int seed) {
                double d0;
                StructurePos globalPos;
                LivingEntity entity;
                if (livingBaseIn == null && !stack.isFramed()) {
                    return 0.0f;
                }
                boolean livingExists = livingBaseIn != null;
                Object object = entity = livingExists ? livingBaseIn : stack.getFrame();
                if (clientLevel == null && entity.level() instanceof ClientLevel) {
                    clientLevel = (ClientLevel)entity.level();
                }
                if ((globalPos = this.getStructurePos(stack)) != null && clientLevel.dimension().location().equals((Object)globalPos.dimensionLocation())) {
                    double d1 = livingExists ? (double)entity.getYRot() : this.getFrameRotation((ItemFrame)entity);
                    d1 = Mth.positiveModulo((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getSpawnToAngle((Entity)entity, globalPos.pos()) / 6.2831854820251465;
                    d0 = 0.5 - (d1 - 0.25 - d2);
                } else {
                    d0 = Math.random();
                }
                if (livingExists) {
                    d0 = this.wobble(clientLevel, d0);
                }
                return Mth.positiveModulo((float)((float)d0), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientLevel clientLevel, double p_185093_2_) {
                if (clientLevel.getGameTime() != this.lastUpdateTick) {
                    this.lastUpdateTick = clientLevel.getGameTime();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = Mth.positiveModulo((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.getDirection();
                int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
                return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + itemFrame.getRotation() * 45 + i));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getSpawnToAngle(Entity entityIn, @NotNull BlockPos pos) {
                return Math.atan2((double)pos.getZ() - entityIn.getZ(), (double)pos.getX() - entityIn.getX());
            }

            @Nullable
            public StructurePos getStructurePos(ItemStack stack) {
                if (stack.has(StructureComponents.STRUCTURE) && stack.has(StructureComponents.STRUCTURE_INFO)) {
                    StructureInfo info = (StructureInfo)stack.get(StructureComponents.STRUCTURE_INFO);
                    assert (info != null);
                    return new StructurePos(info.pos(), info.dimension().location());
                }
                return null;
            }
        }));
    }

    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(KEY_TOGGLE);
    }

    public static void openStructureScreen(InteractionHand hand, ItemStack stack, List<ResourceLocation> allStructures) {
        CompassScreen screen = new CompassScreen(hand, stack, allStructures);
        Minecraft.getInstance().setScreen((Screen)screen);
    }

    public record StructurePos(BlockPos pos, ResourceLocation dimensionLocation) {
    }
}

