/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.screen;

import com.mrbysco.structurecompass.client.screen.widget.StructureListWidget;
import com.mrbysco.structurecompass.compat.gamestages.GameStagesHelper;
import com.mrbysco.structurecompass.network.message.SetStructurePayload;
import com.mrbysco.structurecompass.registry.StructureComponents;
import com.mrbysco.structurecompass.util.StructureUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.neoforge.network.PacketDistributor;

public class CompassScreen
extends Screen {
    private static final int PADDING = 6;
    private StructureListWidget structureWidget;
    private StructureListWidget.ListEntry selected = null;
    private int listWidth;
    private List<ResourceLocation> structures;
    private final List<ResourceLocation> unsortedStructures;
    private Button loadButton;
    private final InteractionHand usedHand;
    private final ItemStack compassStack;
    private final int buttonMargin = 1;
    private final int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public CompassScreen(InteractionHand hand, ItemStack compass, List<ResourceLocation> allStructures) {
        super((Component)Component.translatable((String)"structurecompass:compass.screen"));
        this.usedHand = hand;
        this.compassStack = compass;
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        for (ResourceLocation id : allStructures) {
            if (id == null) continue;
            structureList.add(id);
        }
        if (ModList.get().isLoaded("gamestages")) {
            structureList.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(location));
        }
        Collections.sort(structureList);
        this.structures = Collections.unmodifiableList(structureList);
        this.unsortedStructures = Collections.unmodifiableList(allStructures);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int centerWidth = this.width / 2;
        for (ResourceLocation structureLocation : this.structures) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().width(structureLocation.toString()) + 10);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.width / 3), 200);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        int structureWidth = this.width - this.listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 200);
        int y = this.height - 20 - 6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).bounds(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).build());
        this.loadButton = Button.builder((Component)Component.translatable((String)"structurecompass.screen.selection.select"), b -> {
            if (this.selected != null) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetStructurePayload(this.usedHand, this.selected.getStructureLocation()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (this.minecraft.player != null && this.selected != null) {
                this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)"structurecompass.screen.selection.selected").withStyle(ChatFormatting.GOLD));
            }
            this.onClose();
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.loadButton);
        this.search = new EditBox(this.getFontRenderer(), centerWidth - this.listWidth / 2 + 6 + 1, y -= 20, this.listWidth - 2, 14, (Component)Component.translatable((String)"structurecompass.screen.search"));
        int fullButtonHeight = 32;
        int n = this.search.getY();
        Objects.requireNonNull(this.getFontRenderer());
        this.structureWidget = new StructureListWidget(this, this.width, fullButtonHeight, n - 9 - 6);
        this.structureWidget.setX(0);
        this.addWidget((GuiEventListener)this.search);
        this.addWidget((GuiEventListener)this.structureWidget);
        this.search.setFocused(false);
        this.search.setCanLoseFocus(true);
        if (this.compassStack.has(StructureComponents.STRUCTURE)) {
            String structure = ((ResourceLocation)this.compassStack.get(StructureComponents.STRUCTURE)).toString();
            this.search.setValue(structure);
        }
        int width = this.listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = Button.builder((Component)SortType.A_TO_Z.getButtonText(), b -> this.resortStructures(SortType.A_TO_Z)).bounds(x, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = Button.builder((Component)SortType.Z_TO_A.getButtonText(), b -> this.resortStructures(SortType.Z_TO_A)).bounds(x += width + 1, 6, width - 1, 20).build();
        this.addRenderableWidget((GuiEventListener)SortType.Z_TO_A.button);
        this.resortStructures(SortType.A_TO_Z);
        this.updateCache();
    }

    public void tick() {
        this.structureWidget.setSelected((AbstractSelectionList.Entry)this.selected);
        if (!this.search.getValue().equals(this.lastFilterText)) {
            this.reloadStructures();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadStructures();
            if (this.sortType == SortType.A_TO_Z) {
                Collections.sort(this.structures);
            } else if (this.sortType == SortType.Z_TO_A) {
                this.structures.sort(Collections.reverseOrder());
            }
            this.checkStages();
            this.structureWidget.refreshList();
            if (this.selected != null) {
                this.selected = this.structureWidget.children().stream().filter(e -> e == this.selected).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildStructureList(Consumer<T> ListViewConsumer, Function<ResourceLocation, T> newEntry) {
        this.structures.forEach(mod -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ResourceLocation)mod)));
    }

    private void reloadStructures() {
        this.structures = this.unsortedStructures.stream().filter(struc -> {
            Component structureName = StructureUtil.getStructureName(struc);
            return StringUtils.toLowerCase((String)structureName.getString()).contains(StringUtils.toLowerCase((String)this.search.getValue()));
        }).collect(Collectors.toList());
        this.checkStages();
        this.lastFilterText = this.search.getValue();
    }

    private void checkStages() {
        if (ModList.get().isLoaded("gamestages")) {
            this.structures.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(location));
        }
    }

    private void resortStructures(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.active = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.structureWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        MutableComponent text = Component.translatable((String)"structurecompass.screen.search");
        Font font = this.getFontRenderer();
        int n = this.width / 2 + 6;
        int n2 = this.search.getY();
        Objects.requireNonNull(this.getFontRenderer());
        guiGraphics.drawCenteredString(font, (Component)text, n, n2 - 9 - 2, 0xFFFFFF);
        this.search.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public void setSelected(StructureListWidget.ListEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        this.loadButton.active = this.selected != null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean flag = super.mouseClicked(mouseX, mouseY, button);
        if (button == 1 && this.search.isMouseOver(mouseX, mouseY)) {
            this.search.setValue("");
        }
        return flag;
    }

    public void resize(Minecraft mc, int width, int height) {
        String s = this.search.getValue();
        SortType sort = this.sortType;
        StructureListWidget.ListEntry selected = this.selected;
        this.init(mc, width, height);
        this.search.setValue(s);
        this.selected = selected;
        if (!this.search.getValue().isEmpty()) {
            this.reloadStructures();
        }
        if (sort != SortType.NORMAL) {
            this.resortStructures(sort);
        }
        this.updateCache();
    }

    public void onClose() {
        this.minecraft.setScreen(null);
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        Component getButtonText() {
            return Component.translatable((String)("structurecompass.screen.search." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

