/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.screen.widget;

import com.mrbysco.structurecompass.client.screen.CompassScreen;
import com.mrbysco.structurecompass.util.StructureUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class StructureListWidget
extends ObjectSelectionList<ListEntry> {
    private final CompassScreen parent;
    private final int listWidth;

    public StructureListWidget(CompassScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraft();
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int getScrollbarPosition() {
        return this.listWidth;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        this.clearEntries();
        this.parent.buildStructureList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((ResourceLocation)location, this.parent));
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final ResourceLocation structureLocation;
        private final CompassScreen parent;

        ListEntry(ResourceLocation location, CompassScreen parent) {
            this.structureLocation = location;
            this.parent = parent;
        }

        public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            Component structureName = StructureUtil.getStructureName(this.structureLocation);
            Font font = this.parent.getFontRenderer();
            guiGraphics.drawString(font, Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)structureName, StructureListWidget.this.listWidth)})), this.parent.width / 2 - font.width((FormattedText)structureName) / 2 + 3, top + 6, 0xFFFFFF, false);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.setSelected(this);
            StructureListWidget.this.setSelected((AbstractSelectionList.Entry)this);
            return false;
        }

        public ResourceLocation getStructureLocation() {
            return this.structureLocation;
        }

        public Component getNarration() {
            return Component.literal((String)this.getStructureLocation().getPath());
        }
    }
}

