/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.network.handler;

import com.mrbysco.structurecompass.items.StructureCompassItem;
import com.mrbysco.structurecompass.network.message.SetStructurePayload;
import com.mrbysco.structurecompass.registry.StructureComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    public static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleStructureData(SetStructurePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack stack;
            Player player = context.player();
            if (player != null && (stack = player.getItemInHand(payload.hand())).getItem() instanceof StructureCompassItem) {
                stack.set(StructureComponents.STRUCTURE, (Object)payload.structureLocation());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"structurecompass.networking.set_structure.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

