/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.network.message;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record OpenCompassPayload(InteractionHand hand, ItemStack compassStack, List<ResourceLocation> structureList) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenCompassPayload> CODEC = CustomPacketPayload.codec(OpenCompassPayload::write, OpenCompassPayload::new);
    public static final CustomPacketPayload.Type<OpenCompassPayload> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"structurecompass", (String)"open_compass"));

    public OpenCompassPayload(RegistryFriendlyByteBuf packetBuffer) {
        this(packetBuffer.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuffer), new ArrayList<ResourceLocation>());
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.structureList.add(packetBuffer.readResourceLocation());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)this.compassStack);
        buf.writeInt(this.structureList.size());
        for (ResourceLocation location : this.structureList) {
            buf.writeResourceLocation(location);
        }
    }
}

