/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.annotations.processor;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.annotations.WillBeDeprecated;

@SupportedAnnotationTypes(value={"software.bluelib.api.annotations.WillBeDeprecated"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
public class WillBeDeprecatedProcessor
extends AbstractProcessor {
    @Override
    public boolean process(@NotNull Set<? extends TypeElement> pAnnotations, @NotNull RoundEnvironment pRoundEnv) {
        for (Element element : pRoundEnv.getElementsAnnotatedWith(WillBeDeprecated.class)) {
            WillBeDeprecated ann = element.getAnnotation(WillBeDeprecated.class);
            if (!ann.showWarning()) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Element " + String.valueOf(element.getSimpleName()) + " is planned for future deprecation: " + ann.reason(), element);
        }
        return false;
    }
}

