/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.event;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.renderer.BlueObjectRenderer;
import software.bluelib.loader.renderer.armor.BlueArmorRenderer;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.block.BlueBlockRenderer;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.BlueEntityRenderer;
import software.bluelib.loader.renderer.entity.BlueReplacedEntityRenderer;
import software.bluelib.loader.renderer.item.BlueItemRenderer;

public interface BlueRenderEvent {
    @NotNull
    public BlueRenderer<?> getRenderer();

    public static abstract class ReplacedEntity
    extends Event
    implements BlueRenderEvent {
        @NotNull
        private final BlueReplacedEntityRenderer<?, ?> renderer;

        public ReplacedEntity(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer) {
            this.renderer = pRenderer;
        }

        @NotNull
        public BlueReplacedEntityRenderer<?, ?> getRenderer() {
            return this.renderer;
        }

        @NotNull
        public net.minecraft.world.entity.Entity getReplacedEntity() {
            return ((BlueReplacedEntityRenderer)this.getRenderer()).getCurrentEntity();
        }

        public static class CompileRenderLayers
        extends ReplacedEntity {
            public CompileRenderLayers(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer) {
                super(pRenderer);
            }

            public void addLayer(@NotNull BlueRenderLayer pRenderLayer) {
                ((BlueReplacedEntityRenderer)this.getRenderer()).addRenderLayer(pRenderLayer);
            }
        }

        public static class Post
        extends ReplacedEntity {
            @NotNull
            private final IRenderContext<?> context;

            public Post(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }

        public static class Pre
        extends ReplacedEntity
        implements ICancellableEvent {
            @NotNull
            private final IRenderContext<?> context;

            public Pre(@NotNull BlueReplacedEntityRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }
    }

    public static abstract class Object
    extends Event
    implements BlueRenderEvent {
        @NotNull
        private final BlueObjectRenderer<?> renderer;

        public Object(@NotNull BlueObjectRenderer<?> pRenderer) {
            this.renderer = pRenderer;
        }

        @NotNull
        public BlueObjectRenderer<?> getRenderer() {
            return this.renderer;
        }

        public static class CompileRenderLayers
        extends Object {
            public CompileRenderLayers(@NotNull BlueObjectRenderer<?> pRenderer) {
                super(pRenderer);
            }

            public void addLayer(@NotNull BlueRenderLayer pRenderLayer) {
                ((BlueObjectRenderer)this.getRenderer()).addRenderLayer(pRenderLayer);
            }
        }

        public static class Post
        extends Object {
            @NotNull
            private final IRenderContext<?> context;

            public Post(@NotNull BlueObjectRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }

        public static class Pre
        extends Object
        implements ICancellableEvent {
            @NotNull
            private final IRenderContext<?> context;

            public Pre(@NotNull BlueObjectRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }
    }

    public static abstract class Item
    extends Event
    implements BlueRenderEvent {
        @NotNull
        private final BlueItemRenderer<?> renderer;

        public Item(@NotNull BlueItemRenderer<?> pRenderer) {
            this.renderer = pRenderer;
        }

        @NotNull
        public BlueItemRenderer<?> getRenderer() {
            return this.renderer;
        }

        @NotNull
        public ItemStack getItemStack() {
            return ((BlueItemRenderer)this.getRenderer()).getCurrentItemStack();
        }

        public static class CompileRenderLayers
        extends Item {
            public CompileRenderLayers(@NotNull BlueItemRenderer<?> pRenderer) {
                super(pRenderer);
            }

            public void addLayer(@NotNull BlueRenderLayer pRenderLayer) {
                ((BlueItemRenderer)this.getRenderer()).addRenderLayer(pRenderLayer);
            }
        }

        public static class Post
        extends Item {
            @NotNull
            private final IRenderContext<?> context;

            public Post(@NotNull BlueItemRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }

        public static class Pre
        extends Item
        implements ICancellableEvent {
            @NotNull
            private final IRenderContext<?> context;

            public Pre(@NotNull BlueItemRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }
    }

    public static abstract class Entity
    extends Event
    implements BlueRenderEvent {
        @NotNull
        private final BlueEntityRenderer<?> renderer;

        public Entity(@NotNull BlueEntityRenderer<?> pRenderer) {
            this.renderer = pRenderer;
        }

        @NotNull
        public BlueEntityRenderer<?> getRenderer() {
            return this.renderer;
        }

        @NotNull
        public net.minecraft.world.entity.Entity getEntity() {
            return (net.minecraft.world.entity.Entity)this.renderer.getAnimatable();
        }

        public static class CompileRenderLayers
        extends Entity {
            public CompileRenderLayers(@NotNull BlueEntityRenderer<?> pRenderer) {
                super(pRenderer);
            }

            public void addLayer(@NotNull BlueRenderLayer pRenderLayer) {
                ((BlueEntityRenderer)this.getRenderer()).addRenderLayer(pRenderLayer);
            }
        }

        public static class Post
        extends Entity {
            @NotNull
            private final IRenderContext<?> context;

            public Post(@NotNull BlueEntityRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }

        public static class Pre
        extends Entity
        implements ICancellableEvent {
            @NotNull
            private final IRenderContext<?> context;

            public Pre(@NotNull BlueEntityRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }
    }

    public static abstract class Block
    extends Event
    implements BlueRenderEvent {
        @NotNull
        private final BlueBlockRenderer<?> renderer;

        public Block(@NotNull BlueBlockRenderer<?> pRenderer) {
            this.renderer = pRenderer;
        }

        @NotNull
        public BlueBlockRenderer<?> getRenderer() {
            return this.renderer;
        }

        @NotNull
        public BlockEntity getBlockEntity() {
            return (BlockEntity)this.getRenderer().getAnimatable();
        }

        public static class CompileRenderLayers
        extends Block {
            public CompileRenderLayers(@NotNull BlueBlockRenderer<?> pRenderer) {
                super(pRenderer);
            }

            public void addLayer(@NotNull BlueRenderLayer pRenderLayer) {
                ((BlueBlockRenderer)this.getRenderer()).addRenderLayer(pRenderLayer);
            }
        }

        public static class Post
        extends Block {
            @NotNull
            private final IRenderContext<?> context;

            public Post(@NotNull BlueBlockRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }

        public static class Pre
        extends Block
        implements ICancellableEvent {
            @NotNull
            private final IRenderContext<?> context;

            public Pre(@NotNull BlueBlockRenderer<?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }
    }

    public static abstract class Armor
    extends Event
    implements BlueRenderEvent {
        @NotNull
        private final BlueArmorRenderer<?, ?> renderer;

        public Armor(@NotNull BlueArmorRenderer<?, ?> pRenderer) {
            this.renderer = pRenderer;
        }

        @NotNull
        public BlueArmorRenderer<?, ?> getRenderer() {
            return this.renderer;
        }

        @Nullable
        public net.minecraft.world.entity.Entity getEntity() {
            return ((BlueArmorRenderer)this.getRenderer()).getCurrentEntity();
        }

        @Nullable
        public ItemStack getItemStack() {
            return ((BlueArmorRenderer)this.getRenderer()).getCurrentStack();
        }

        @Nullable
        public EquipmentSlot getEquipmentSlot() {
            return ((BlueArmorRenderer)this.getRenderer()).getCurrentSlot();
        }

        public static class CompileRenderLayers
        extends Armor {
            public CompileRenderLayers(@NotNull BlueArmorRenderer<?, ?> pRenderer) {
                super(pRenderer);
            }

            public void addLayer(@NotNull BlueRenderLayer pRenderLayer) {
                ((BlueArmorRenderer)this.getRenderer()).addRenderLayer(pRenderLayer);
            }
        }

        public static class Post
        extends Armor {
            @NotNull
            private final IRenderContext<?> context;

            public Post(@NotNull BlueArmorRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }

        public static class Pre
        extends Armor
        implements ICancellableEvent {
            @NotNull
            private final IRenderContext<?> context;

            public Pre(@NotNull BlueArmorRenderer<?, ?> pRenderer, @NotNull IRenderContext<?> pContext) {
                super(pRenderer);
                this.context = pContext;
            }

            @NotNull
            public IRenderContext<?> getContext() {
                return this.context;
            }
        }
    }
}

