/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.range;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.range.LongRange;

public record LongRangeCache(@NotNull Long min, @NotNull Long max) {
    @NotNull
    public static final Codec<LongRangeCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)LongRangeCache.readFromNBT(tag));
    }, longRangeCache -> {
        CompoundTag tag = new CompoundTag();
        longRangeCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<LongRangeCache> LONG_RANGE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putLong("Min", this.min.longValue());
        pTag.putLong("Max", this.max.longValue());
    }

    @NotNull
    public static LongRangeCache readFromNBT(@NotNull CompoundTag pTag) {
        return new LongRangeCache(pTag.getLong("Min"), pTag.getLong("Max"));
    }

    public long getRandomValue() {
        return ThreadLocalRandom.current().nextLong() * (this.max - this.min) + this.min;
    }

    @NotNull
    public static LongRangeCache construct(@NotNull LongRange pLongRange) {
        return new LongRangeCache(pLongRange.min(), pLongRange.max());
    }
}

