/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context;

import software.bluelib.api.molang.context.BaseMoLangContext;
import software.bluelib.api.molang.context.math.MoLangMathUtils;

public class OperatorMoLang
extends BaseMoLangContext {
    public OperatorMoLang() {
        this.Arithmetic();
        this.Unary();
        this.Comparison();
    }

    private void Arithmetic() {
        this.registerFunction("add", (arguments, runtime) -> {
            double sum = 0.0;
            for (Object arg : arguments) {
                sum += MoLangMathUtils.toDouble(arg).doubleValue();
            }
            return sum;
        });
        this.registerFunction("subtract", (arguments, runtime) -> {
            if (arguments.isEmpty()) {
                return 0.0;
            }
            double result = MoLangMathUtils.toDouble(arguments.getFirst());
            for (int i = 1; i < arguments.size(); ++i) {
                result -= MoLangMathUtils.toDouble(arguments.get(i)).doubleValue();
            }
            return result;
        });
        this.registerFunction("multiply", (arguments, runtime) -> {
            double result = 1.0;
            for (Object arg : arguments) {
                result *= MoLangMathUtils.toDouble(arg).doubleValue();
            }
            return result;
        });
        this.registerFunction("divide", (arguments, runtime) -> {
            if (arguments.isEmpty()) {
                return 0.0;
            }
            double result = MoLangMathUtils.toDouble(arguments.getFirst());
            for (int i = 1; i < arguments.size(); ++i) {
                double divisor = MoLangMathUtils.toDouble(arguments.get(i));
                if (divisor == 0.0) {
                    return 0.0;
                }
                result /= divisor;
            }
            return result;
        });
        this.registerFunction("modulus", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return 0.0;
            }
            double a = MoLangMathUtils.toDouble(arguments.get(0));
            double b = MoLangMathUtils.toDouble(arguments.get(1));
            if (b == 0.0) {
                return 0.0;
            }
            return a % b;
        });
        this.registerFunction("negate", (arguments, runtime) -> {
            if (arguments.isEmpty()) {
                return 0.0;
            }
            return -MoLangMathUtils.toDouble(arguments.getFirst()).doubleValue();
        });
    }

    private void Unary() {
        this.registerFunction("increment", (arguments, runtime) -> {
            if (arguments.isEmpty()) {
                return 1.0;
            }
            return MoLangMathUtils.toDouble(arguments.getFirst()) + 1.0;
        });
        this.registerFunction("decrement", (arguments, runtime) -> {
            if (arguments.isEmpty()) {
                return -1.0;
            }
            return MoLangMathUtils.toDouble(arguments.getFirst()) - 1.0;
        });
    }

    private void Comparison() {
        this.registerFunction("equals", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return false;
            }
            return MoLangMathUtils.toDouble(arguments.get(0)).equals(MoLangMathUtils.toDouble(arguments.get(1)));
        });
        this.registerFunction("not_equals", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return false;
            }
            return !MoLangMathUtils.toDouble(arguments.get(0)).equals(MoLangMathUtils.toDouble(arguments.get(1)));
        });
        this.registerFunction("less_than", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return false;
            }
            return MoLangMathUtils.toDouble(arguments.get(0)) < MoLangMathUtils.toDouble(arguments.get(1));
        });
        this.registerFunction("less_than_or_equal", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return false;
            }
            return MoLangMathUtils.toDouble(arguments.get(0)) <= MoLangMathUtils.toDouble(arguments.get(1));
        });
        this.registerFunction("greater_than", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return false;
            }
            return MoLangMathUtils.toDouble(arguments.get(0)) > MoLangMathUtils.toDouble(arguments.get(1));
        });
        this.registerFunction("greater_than_or_equal", (arguments, runtime) -> {
            if (arguments.size() < 2) {
                return false;
            }
            return MoLangMathUtils.toDouble(arguments.get(0)) >= MoLangMathUtils.toDouble(arguments.get(1));
        });
    }
}

