/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.entity.animal;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.molang.context.BaseMoLangContext;

public class TamableAnimalMoLang
extends BaseMoLangContext {
    public TamableAnimalMoLang(@NotNull Supplier<TamableAnimal> pTamableAnimalSup) {
        TamableAnimal tamableAnimal = pTamableAnimalSup.get();
        this.setVariable("teleport_when_distance_is_sq", 144);
        this.setVariable("is_tame", tamableAnimal.isTame());
        this.setVariable("is_in_sitting_pose", tamableAnimal.isInSittingPose());
        this.setVariable("is_ordered_to_sit", tamableAnimal.isOrderedToSit());
        this.setVariable("should_try_teleport_to_owner", tamableAnimal.shouldTryTeleportToOwner());
        this.setVariable("unable_to_move_to_owner", tamableAnimal.unableToMoveToOwner());
        this.registerFunction("set_tame", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof Boolean) && !(args.get(1) instanceof Boolean)) {
                return tamableAnimal.isTame();
            }
            boolean tame = (Boolean)args.getFirst();
            boolean applyTamingSideEffects = (Boolean)args.get(1);
            tamableAnimal.setTame(tame, applyTamingSideEffects);
            return tamableAnimal.isTame();
        });
        this.registerFunction("set_in_sitting_pose", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Boolean)) {
                return tamableAnimal.isInSittingPose();
            }
            Boolean sitting = (Boolean)patt0$temp;
            tamableAnimal.setInSittingPose(sitting.booleanValue());
            return tamableAnimal.isInSittingPose();
        });
        this.registerFunction("set_owner_uuid", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof UUID)) {
                return tamableAnimal.getOwnerUUID();
            }
            UUID owner = (UUID)patt0$temp;
            tamableAnimal.setOwnerUUID(owner);
            return tamableAnimal.getOwnerUUID();
        });
        this.registerFunction("tame", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Player)) {
                return tamableAnimal.isTame();
            }
            Player owner = (Player)patt0$temp;
            tamableAnimal.tame(owner);
            return tamableAnimal.isTame();
        });
        this.registerFunction("is_owned_by", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof LivingEntity)) {
                return false;
            }
            LivingEntity owner = (LivingEntity)patt0$temp;
            return tamableAnimal.isOwnedBy(owner);
        });
        this.registerFunction("wants_to_attack", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof LivingEntity) && !(args.get(1) instanceof LivingEntity)) {
                return false;
            }
            LivingEntity target = (LivingEntity)args.getFirst();
            LivingEntity owner = (LivingEntity)args.get(1);
            return tamableAnimal.wantsToAttack(target, owner);
        });
        this.registerFunction("set_ordered_to_sit", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Boolean)) {
                return tamableAnimal.isOrderedToSit();
            }
            Boolean order = (Boolean)patt0$temp;
            tamableAnimal.setOrderedToSit(order.booleanValue());
            return tamableAnimal.isOrderedToSit();
        });
        this.registerFunction("try_to_teleport_to_owner", (args, runtime) -> {
            tamableAnimal.tryToTeleportToOwner();
            return true;
        });
    }
}

