/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.entity.mob;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.molang.context.BaseMoLangContext;

public class AgeableMobMoLang
extends BaseMoLangContext {
    public AgeableMobMoLang(@NotNull Supplier<AgeableMob> pAgeableMobSup) {
        AgeableMob ageableMob = pAgeableMobSup.get();
        this.setVariable("get_age", ageableMob.getAge());
        this.setVariable("can_breed", ageableMob.canBreed());
        this.setVariable("baby_start_age", -24000);
        this.registerFunction("get_breed_offspring", (args, runtime) -> {
            if (args.size() != 2 || !(args.getFirst() instanceof ServerLevel) && !(args.get(1) instanceof AgeableMob)) {
                return false;
            }
            ServerLevel level = (ServerLevel)args.getFirst();
            AgeableMob mate = (AgeableMob)args.get(1);
            return ageableMob.getBreedOffspring(level, mate);
        });
        this.registerFunction("age_up", (args, runtime) -> {
            Object patt0$temp;
            if (args.isEmpty()) {
                return ageableMob.getAge();
            }
            Object first = args.getFirst();
            if (!(first instanceof Number)) {
                return ageableMob.getAge();
            }
            int amount = ((Number)first).intValue();
            if (args.size() == 1) {
                ageableMob.ageUp(amount);
            } else if (args.size() == 2 && (patt0$temp = args.get(1)) instanceof Boolean) {
                Boolean forced = (Boolean)patt0$temp;
                ageableMob.ageUp(amount, forced.booleanValue());
            }
            return ageableMob.getAge();
        });
        this.registerFunction("set_age", (args, runtime) -> {
            Object patt0$temp;
            if (args.size() != 1 || !((patt0$temp = args.getFirst()) instanceof Number)) {
                return ageableMob.getAge();
            }
            Number age = (Number)patt0$temp;
            int setAge = age.intValue();
            ageableMob.setAge(setAge);
            return ageableMob.getAge();
        });
    }
}

