/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.molang.context.math;

import software.bluelib.api.molang.MoLangNamespaceUtils;
import software.bluelib.api.molang.context.BaseMoLangContext;
import software.bluelib.api.molang.context.math.MoLangMathUtils;

public class BasicMathMoLang
extends BaseMoLangContext {
    public BasicMathMoLang() {
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("round"), (args, runtime) -> {
            double value = MoLangMathUtils.toDouble(args, 0);
            int decimals = MoLangMathUtils.toDouble(args, 1, 0.0).intValue();
            double factor = Math.pow(10.0, decimals);
            return (double)Math.round(value * factor) / factor;
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("floor"), (args, runtime) -> Math.floor(MoLangMathUtils.toDouble(args, 0)));
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("ceil"), (args, runtime) -> Math.ceil(MoLangMathUtils.toDouble(args, 0)));
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("abs"), (args, runtime) -> Math.abs(MoLangMathUtils.toDouble(args, 0)));
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("clamp"), (args, runtime) -> {
            double value = MoLangMathUtils.toDouble(args, 0);
            double min = MoLangMathUtils.toDouble(args, 1);
            double max = MoLangMathUtils.toDouble(args, 2);
            return Math.max(min, Math.min(max, value));
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("min"), (args, runtime) -> args.stream().mapToDouble(MoLangMathUtils::toDouble).min().orElse(0.0));
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("max"), (args, runtime) -> args.stream().mapToDouble(MoLangMathUtils::toDouble).max().orElse(0.0));
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("mod"), (args, runtime) -> {
            double a = MoLangMathUtils.toDouble(args, 0);
            double b = MoLangMathUtils.toDouble(args, 1);
            return a % b;
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("trunc"), (args, runtime) -> {
            double value = MoLangMathUtils.toDouble(args, 0);
            return value < 0.0 ? Math.ceil(value) : Math.floor(value);
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("lerp"), (args, runtime) -> {
            double a = MoLangMathUtils.toDouble(args, 0);
            double b = MoLangMathUtils.toDouble(args, 1);
            double t = MoLangMathUtils.toDouble(args, 2);
            return a + (b - a) * t;
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("lerprotate"), (args, runtime) -> {
            double a = MoLangMathUtils.toDouble(args, 0);
            double b = MoLangMathUtils.toDouble(args, 1);
            double t = MoLangMathUtils.toDouble(args, 2);
            double delta = (b - a + 180.0) % 360.0 - 180.0;
            return a + delta * t;
        });
        this.registerFunction(MoLangNamespaceUtils.withMathNamespace("hermite_blend"), (args, runtime) -> {
            double t = MoLangMathUtils.toDouble(args, 0);
            return t * t * (3.0 - 2.0 * t);
        });
    }
}

