/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.net;

import java.util.function.Predicate;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.net.Encodable;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public interface NetworkPacket<T extends NetworkPacket<T>>
extends CustomPacketPayload,
Encodable {
    @NotNull
    public ResourceLocation getId();

    default public void sendToPlayer(@NotNull ServerPlayer pPlayer) {
        NetworkRegistry.sendPacketToPlayer(pPlayer, this);
    }

    default public void sendToPlayers(@NotNull Iterable<ServerPlayer> pPlayers) {
        if (pPlayers.iterator().hasNext()) {
            NetworkRegistry.sendPacketToPlayers(pPlayers, this);
        }
    }

    default public void sendToAllPlayers() {
        NetworkRegistry.sendToAllPlayers(this);
    }

    default public void sendToServer() {
        NetworkRegistry.sendToServer(this);
    }

    default public void sendToPlayersAround(@NotNull Double pX, @NotNull Double pY, @NotNull Double pZ, @NotNull Double pDistance, @NotNull ResourceKey<Level> pWorldKey, @NotNull Predicate<ServerPlayer> pExclusionCondition) {
        MinecraftServer server = BlueLibConstants.PlatformHelper.PLATFORM.getServer();
        if (server == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.translate("server.null"));
            return;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            double zDiff;
            double yDiff;
            double xDiff;
            if (pExclusionCondition.test(player) || !player.level().dimension().equals(pWorldKey) || !((xDiff = pX - player.getX()) * xDiff + (yDiff = pY - player.getY()) * yDiff + (zDiff = pZ - player.getZ()) * zDiff < pDistance * pDistance)) continue;
            NetworkRegistry.sendPacketToPlayer(player, this);
        }
    }

    default public void sendToPlayersAround(@NotNull Double pX, @NotNull Double pY, @NotNull Double pZ, @NotNull Double pDistance, @NotNull ResourceKey<Level> pWorldKey) {
        this.sendToPlayersAround(pX, pY, pZ, pDistance, pWorldKey, player -> false);
    }

    @NotNull
    default public CustomPacketPayload.Type<T> type() {
        return new CustomPacketPayload.Type(this.getId());
    }
}

