/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.math;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class StatisticalUtils {
    private StatisticalUtils() {
    }

    @NotNull
    public static Double calculateMean(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "mean"));
            return 0.0;
        }
        double sum = 0.0;
        for (double value : pValues) {
            sum += value;
        }
        return sum / (double)pValues.length;
    }

    @NotNull
    public static Double calculateMedian(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "median"));
            return 0.0;
        }
        double[] sorted = (double[])pValues.clone();
        Arrays.sort(sorted);
        int middle = sorted.length / 2;
        return sorted.length % 2 == 0 ? (sorted[middle - 1] + sorted[middle]) / 2.0 : sorted[middle];
    }

    @NotNull
    public static Double calculateMode(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "mode"));
            return 0.0;
        }
        HashMap<Double, Integer> frequencyMap = new HashMap<Double, Integer>();
        for (double value : pValues) {
            frequencyMap.put(value, frequencyMap.getOrDefault(value, 0) + 1);
        }
        double mode = pValues[0];
        int maxCount = 0;
        for (Map.Entry entry : frequencyMap.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            maxCount = (Integer)entry.getValue();
            mode = (Double)entry.getKey();
        }
        return mode;
    }

    @NotNull
    public static Double calculateStandardDeviation(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "standard deviation"));
            return 0.0;
        }
        double mean = StatisticalUtils.calculateMean(pValues);
        double sumSquaredDifferences = 0.0;
        double[] dArray = pValues;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            @NotNull Double value = dArray[i];
            sumSquaredDifferences += Math.pow(value - mean, 2.0);
        }
        return Math.sqrt(sumSquaredDifferences / (double)pValues.length);
    }

    @NotNull
    public static Double calculateVariance(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "variance"));
            return 0.0;
        }
        double mean = StatisticalUtils.calculateMean(pValues);
        double sumSquaredDifferences = 0.0;
        for (double value : pValues) {
            sumSquaredDifferences += Math.pow(value - mean, 2.0);
        }
        return sumSquaredDifferences / (double)pValues.length;
    }

    @NotNull
    public static Double calculateRange(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "range"));
            return 0.0;
        }
        double max = Arrays.stream(pValues).max().orElseThrow();
        double min = Arrays.stream(pValues).min().orElseThrow();
        return max - min;
    }

    @NotNull
    public static Double calculateCoefficientOfVariation(double[] pValues) {
        if (pValues.length == 0) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("math.null", "array", "coefficient of variation"));
            return 0.0;
        }
        @NotNull Double mean = StatisticalUtils.calculateMean(pValues);
        @NotNull Double stdDev = StatisticalUtils.calculateStandardDeviation(pValues);
        return stdDev / mean * 100.0;
    }
}

