/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.minecraft;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundTagUtils {
    public static <K, V> void writeMap(@NotNull CompoundTag pTag, @NotNull String pKey, @NotNull Map<K, V> pMap, @NotNull BiConsumer<CompoundTag, K> pKeyWriter, @NotNull BiConsumer<CompoundTag, V> pValueWriter, @NotNull String pKeyFieldName, @NotNull String pValueFieldName) {
        ListTag list = new ListTag();
        for (Map.Entry<K, V> entry : pMap.entrySet()) {
            CompoundTag pairTag = new CompoundTag();
            CompoundTag keyTag = new CompoundTag();
            CompoundTag valueTag = new CompoundTag();
            pKeyWriter.accept(keyTag, entry.getKey());
            pValueWriter.accept(valueTag, entry.getValue());
            pairTag.put(pKeyFieldName, (Tag)keyTag);
            pairTag.put(pValueFieldName, (Tag)valueTag);
            list.add((Object)pairTag);
        }
        pTag.put(pKey, (Tag)list);
    }

    @NotNull
    public static <K, V> Map<K, V> readMap(@NotNull CompoundTag pTag, @NotNull String pKey, @NotNull Function<CompoundTag, K> pKeyReader, @NotNull Function<CompoundTag, V> pValueReader, @NotNull String pKeyFieldName, @NotNull String pValueFieldName) {
        HashMap<K, V> map = new HashMap<K, V>();
        ListTag list = pTag.getList(pKey, 10);
        for (Tag element : list) {
            if (!(element instanceof CompoundTag)) continue;
            CompoundTag pairTag = (CompoundTag)element;
            CompoundTag keyTag = pairTag.getCompound(pKeyFieldName);
            CompoundTag valueTag = pairTag.getCompound(pValueFieldName);
            K key = pKeyReader.apply(keyTag);
            V value = pValueReader.apply(valueTag);
            map.put(key, value);
        }
        return map;
    }

    public static void writeJsonArray(@NotNull CompoundTag pTag, @NotNull String pKey, @Nullable JsonArray pArray) {
        if (pArray == null) {
            pArray = new JsonArray();
        }
        pTag.putString(pKey, pArray.toString());
    }

    @NotNull
    public static JsonArray readJsonArray(@NotNull CompoundTag pTag, @NotNull String pKey) {
        String json = pTag.getString(pKey);
        return JsonParser.parseString((String)json).getAsJsonArray();
    }

    public static <T> void writeList(@NotNull CompoundTag pTag, @NotNull String pKey, @NotNull List<T> pList, @NotNull BiConsumer<CompoundTag, T> pElementWriter) {
        ListTag listTag = new ListTag();
        for (T element : pList) {
            CompoundTag elementTag = new CompoundTag();
            pElementWriter.accept(elementTag, (CompoundTag)element);
            listTag.add((Object)elementTag);
        }
        pTag.put(pKey, (Tag)listTag);
    }

    @NotNull
    public static <T> List<T> readList(@NotNull CompoundTag pTag, @NotNull String pKey, @NotNull Function<CompoundTag, T> pElementReader) {
        ListTag listTag = pTag.getList(pKey, 10);
        ArrayList<T> result = new ArrayList<T>();
        for (Tag tag : listTag) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag elementTag = (CompoundTag)tag;
            result.add(pElementReader.apply(elementTag));
        }
        return result;
    }
}

