/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.base;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.cache.AnimatableInstanceCache;
import software.bluelib.loader.animatable.cache.InstancedAnimatableInstanceCache;
import software.bluelib.loader.animatable.cache.SingletonAnimatableInstanceCache;

public interface BlueAnimatable {
    @NotNull
    public static final Map<BlueAnimatable, AnimatableInstanceCache<BlueAnimatable>> CACHE = new WeakHashMap<BlueAnimatable, AnimatableInstanceCache<BlueAnimatable>>();

    @NotNull
    public ResourceLocation getControllerResource();

    default public <T extends BlueAnimatable> void registerControllers(@NotNull AnimatableManager.ControllerRegistrar<T> pRegistrar) {
    }

    @NotNull
    default public AnimatableInstanceCache<? extends BlueAnimatable> getAnimatableInstanceCache() {
        AnimatableInstanceCache<? extends BlueAnimatable> customCache = this.useCustomCache();
        if (customCache != null) {
            return customCache;
        }
        return CACHE.computeIfAbsent(this, k -> this.useSingletonCache() ? new SingletonAnimatableInstanceCache((BlueAnimatable)k) : new InstancedAnimatableInstanceCache((BlueAnimatable)k));
    }

    default public boolean useSingletonCache() {
        return false;
    }

    @NotNull
    default public Double boneResetTime() {
        return 5.0;
    }

    default public boolean playWhilePaused() {
        return false;
    }

    @NotNull
    public Double getTick(@NotNull Object var1);

    @Nullable
    default public AnimatableInstanceCache<? extends BlueAnimatable> useCustomCache() {
        return null;
    }
}

