/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector4f;
import software.bluelib.loader.animation.bone.BoneSnapshot;
import software.bluelib.loader.cache.model.CubeCache;

public class BoneCache {
    @Nullable
    private final BoneCache parent;
    @Nullable
    private final String name;
    @NotNull
    private final List<BoneCache> children = new ObjectArrayList();
    @NotNull
    private final List<CubeCache> cubes = new ObjectArrayList();
    @Nullable
    private final Boolean mirror;
    @Nullable
    private final Float inflate;
    @Nullable
    private final Boolean dontRender;
    @Nullable
    private final Boolean reset;
    @Nullable
    private BoneSnapshot initialSnapshot;
    private boolean hidden;
    private boolean childrenHidden = false;
    @NotNull
    private Float scaleX = Float.valueOf(1.0f);
    @NotNull
    private Float scaleY = Float.valueOf(1.0f);
    @NotNull
    private Float scaleZ = Float.valueOf(1.0f);
    private float positionX;
    private float positionY;
    private float positionZ;
    private float pivotX;
    private float pivotY;
    private float pivotZ;
    private float rotX;
    private float rotY;
    private float rotZ;
    private boolean positionChanged = false;
    private boolean rotationChanged = false;
    private boolean scaleChanged = false;
    @NotNull
    private final Matrix4f modelSpaceMatrix = new Matrix4f();
    @NotNull
    private final Matrix4f localSpaceMatrix = new Matrix4f();
    @NotNull
    private final Matrix4f worldSpaceMatrix = new Matrix4f();
    @NotNull
    private Matrix3f worldSpaceNormal = new Matrix3f();
    private boolean trackingMatrices;

    public BoneCache(@Nullable BoneCache pParent, @Nullable String pName, @Nullable Boolean pMirror, @Nullable Float pInflate, @Nullable Boolean pDontRender, @Nullable Boolean pReset) {
        this.parent = pParent;
        this.name = pName;
        this.mirror = pMirror;
        this.inflate = pInflate;
        this.dontRender = pDontRender;
        this.reset = pReset;
        this.trackingMatrices = false;
        this.hidden = this.dontRender == Boolean.TRUE;
        this.worldSpaceNormal.identity();
        this.worldSpaceMatrix.identity();
        this.localSpaceMatrix.identity();
        this.modelSpaceMatrix.identity();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public BoneCache getParent() {
        return this.parent;
    }

    public float getRotX() {
        return this.rotX;
    }

    public float getRotY() {
        return this.rotY;
    }

    public float getRotZ() {
        return this.rotZ;
    }

    public float getPosX() {
        return this.positionX;
    }

    public float getPosY() {
        return this.positionY;
    }

    public float getPosZ() {
        return this.positionZ;
    }

    @NotNull
    public Float getScaleX() {
        return this.scaleX;
    }

    @NotNull
    public Float getScaleY() {
        return this.scaleY;
    }

    @NotNull
    public Float getScaleZ() {
        return this.scaleZ;
    }

    public void setRotX(float pValue) {
        this.rotX = pValue;
        this.markRotationAsChanged();
    }

    public void setRotY(float pValue) {
        this.rotY = pValue;
        this.markRotationAsChanged();
    }

    public void setRotZ(float pValue) {
        this.rotZ = pValue;
        this.markRotationAsChanged();
    }

    public void updateRotation(float pXRot, float pYRot, float pZRot) {
        this.setRotX(pXRot);
        this.setRotY(pYRot);
        this.setRotZ(pZRot);
    }

    public void setPosX(float pValue) {
        this.positionX = pValue;
        this.markPositionAsChanged();
    }

    public void setPosY(float pValue) {
        this.positionY = pValue;
        this.markPositionAsChanged();
    }

    public void setPosZ(float pValue) {
        this.positionZ = pValue;
        this.markPositionAsChanged();
    }

    public void updatePosition(float pPosX, float pPosY, float pPosZ) {
        this.setPosX(pPosX);
        this.setPosY(pPosY);
        this.setPosZ(pPosZ);
    }

    public void setScaleX(@NotNull Float pValue) {
        this.scaleX = pValue;
        this.markScaleAsChanged();
    }

    public void setScaleY(@NotNull Float pValue) {
        this.scaleY = pValue;
        this.markScaleAsChanged();
    }

    public void setScaleZ(@NotNull Float pValue) {
        this.scaleZ = pValue;
        this.markScaleAsChanged();
    }

    public void updateScale(float pScaleX, float pScaleY, float pScaleZ) {
        this.setScaleX(Float.valueOf(pScaleX));
        this.setScaleY(Float.valueOf(pScaleY));
        this.setScaleZ(Float.valueOf(pScaleZ));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean pHidden) {
        this.hidden = pHidden;
        this.setChildrenHidden(pHidden);
    }

    public void setChildrenHidden(boolean pHideChildren) {
        this.childrenHidden = pHideChildren;
    }

    public void setPivotX(float pValue) {
        this.pivotX = pValue;
    }

    public void setPivotY(float pValue) {
        this.pivotY = pValue;
    }

    public void setPivotZ(float pValue) {
        this.pivotZ = pValue;
    }

    public void updatePivot(float pPivotX, float pPivotY, float pPivotZ) {
        this.setPivotX(pPivotX);
        this.setPivotY(pPivotY);
        this.setPivotZ(pPivotZ);
    }

    public float getPivotX() {
        return this.pivotX;
    }

    public float getPivotY() {
        return this.pivotY;
    }

    public float getPivotZ() {
        return this.pivotZ;
    }

    public boolean isHidingChildren() {
        return this.childrenHidden;
    }

    public void markScaleAsChanged() {
        this.scaleChanged = true;
    }

    public void markRotationAsChanged() {
        this.rotationChanged = true;
    }

    public void markPositionAsChanged() {
        this.positionChanged = true;
    }

    public boolean hasScaleChanged() {
        return this.scaleChanged;
    }

    public boolean hasRotationChanged() {
        return this.rotationChanged;
    }

    public boolean hasPositionChanged() {
        return this.positionChanged;
    }

    public void resetStateChanges() {
        this.scaleChanged = false;
        this.rotationChanged = false;
        this.positionChanged = false;
    }

    @Nullable
    public BoneSnapshot getInitialSnapshot() {
        return this.initialSnapshot;
    }

    @NotNull
    public List<BoneCache> getChildBones() {
        return this.children;
    }

    public void saveInitialSnapshot() {
        if (this.initialSnapshot == null) {
            this.initialSnapshot = this.saveSnapshot();
        }
    }

    @Nullable
    public Boolean getMirror() {
        return this.mirror;
    }

    @Nullable
    public Float getInflate() {
        return this.inflate;
    }

    @Nullable
    public Boolean shouldNeverRender() {
        return this.dontRender;
    }

    @Nullable
    public Boolean getReset() {
        return this.reset;
    }

    @NotNull
    public List<CubeCache> getCubes() {
        return this.cubes;
    }

    public boolean isTrackingMatrices() {
        return this.trackingMatrices;
    }

    public void setTrackingMatrices(boolean pTrackingMatrices) {
        this.trackingMatrices = pTrackingMatrices;
    }

    @NotNull
    public Matrix4f getModelSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.modelSpaceMatrix;
    }

    public void setModelSpaceMatrix(@NotNull Matrix4f pMatrix) {
        this.modelSpaceMatrix.set((Matrix4fc)pMatrix);
    }

    @NotNull
    public Matrix4f getLocalSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.localSpaceMatrix;
    }

    public void setLocalSpaceMatrix(@NotNull Matrix4f pMatrix) {
        this.localSpaceMatrix.set((Matrix4fc)pMatrix);
    }

    @NotNull
    public Matrix4f getWorldSpaceMatrix() {
        this.setTrackingMatrices(true);
        return this.worldSpaceMatrix;
    }

    public void setWorldSpaceMatrix(@NotNull Matrix4f pMatrix) {
        this.worldSpaceMatrix.set((Matrix4fc)pMatrix);
    }

    public void setWorldSpaceNormal(@NotNull Matrix3f pMatrix) {
        this.worldSpaceNormal = pMatrix;
    }

    @NotNull
    public Matrix3f getWorldSpaceNormal() {
        return this.worldSpaceNormal;
    }

    @NotNull
    public Vector3d getLocalPosition() {
        Vector4f vec = this.getLocalSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    @NotNull
    public Vector3d getModelPosition() {
        Vector4f vec = this.getModelSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)(-vec.x() * 16.0f), (double)(vec.y() * 16.0f), (double)(vec.z() * 16.0f));
    }

    @NotNull
    public Vector3d getWorldPosition() {
        Vector4f vec = this.getWorldSpaceMatrix().transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vector3d((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public void setModelPosition(@NotNull Vector3d pPos) {
        BoneCache parent = this.getParent();
        Matrix4f matrix = (parent == null ? new Matrix4f().identity() : new Matrix4f((Matrix4fc)parent.getModelSpaceMatrix())).invert();
        Vector4f vec = matrix.transform(new Vector4f(-((float)pPos.x) / 16.0f, (float)pPos.y / 16.0f, (float)pPos.z / 16.0f, 1.0f));
        this.updatePosition(-vec.x() * 16.0f, vec.y() * 16.0f, vec.z() * 16.0f);
    }

    @NotNull
    public Matrix4f getModelRotationMatrix() {
        Matrix4f matrix = new Matrix4f((Matrix4fc)this.getModelSpaceMatrix());
        matrix.m03(0.0f);
        matrix.m13(0.0f);
        matrix.m23(0.0f);
        return matrix;
    }

    @NotNull
    public Vector3d getPositionVector() {
        return new Vector3d((double)this.getPosX(), (double)this.getPosY(), (double)this.getPosZ());
    }

    @NotNull
    public Vector3d getRotationVector() {
        return new Vector3d((double)this.getRotX(), (double)this.getRotY(), (double)this.getRotZ());
    }

    @NotNull
    public Vector3d getScaleVector() {
        return new Vector3d((double)this.getScaleX().floatValue(), (double)this.getScaleY().floatValue(), (double)this.getScaleZ().floatValue());
    }

    public void addRotationOffsetFromBone(@NotNull BoneCache pSource) {
        this.setRotX(this.getRotX() + pSource.getRotX() - pSource.getInitialSnapshot().getRotX());
        this.setRotY(this.getRotY() + pSource.getRotY() - pSource.getInitialSnapshot().getRotY());
        this.setRotZ(this.getRotZ() + pSource.getRotZ() - pSource.getInitialSnapshot().getRotZ());
    }

    @NotNull
    public BoneSnapshot saveSnapshot() {
        return new BoneSnapshot(this);
    }

    public boolean equals(@Nullable Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj == null || this.getClass() != pObj.getClass()) {
            return false;
        }
        return this.hashCode() == pObj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getParent() != null ? this.getParent().getName() : Integer.valueOf(0), this.getCubes().size(), this.getChildBones().size());
    }
}

